/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.module.tem.service.impl;

import java.sql.Date;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.coa.businessobject.ObjectCode;
import org.kuali.kfs.module.tem.batch.service.ImportedExpensePendingEntryService;
import org.kuali.kfs.module.tem.businessobject.AccountingDistribution;
import org.kuali.kfs.module.tem.businessobject.ExpenseTypeObjectCode;
import org.kuali.kfs.module.tem.businessobject.HistoricalExpenseAsTemExpenseWrapper;
import org.kuali.kfs.module.tem.businessobject.HistoricalTravelExpense;
import org.kuali.kfs.module.tem.businessobject.ImportedExpense;
import org.kuali.kfs.module.tem.businessobject.TemExpense;
import org.kuali.kfs.module.tem.businessobject.TemSourceAccountingLine;
import org.kuali.kfs.module.tem.document.TravelDocument;
import org.kuali.kfs.module.tem.service.CreditCardAgencyService;
import org.kuali.kfs.module.tem.service.TemExpenseService;
import org.kuali.kfs.module.tem.service.TravelExpenseService;
import org.kuali.kfs.module.tem.service.impl.ExpenseServiceBase;
import org.kuali.kfs.module.tem.util.ExpenseUtils;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySequenceHelper;
import org.kuali.kfs.sys.businessobject.GeneralLedgerPendingEntrySourceDetail;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.rice.core.api.util.type.AbstractKualiDecimal;
import org.kuali.rice.core.api.util.type.KualiDecimal;

public class ImportedCorporateCardExpenseServiceImpl
extends ExpenseServiceBase
implements TemExpenseService {
    protected static Logger LOG = Logger.getLogger(ImportedCorporateCardExpenseServiceImpl.class);
    protected ImportedExpensePendingEntryService importedExpensePendingEntryService;
    protected CreditCardAgencyService creditCardAgencyService;

    @Override
    public void calculateDistributionTotals(TravelDocument document, Map<String, AccountingDistribution> distributionMap, List<? extends TemExpense> expenses) {
        String defaultChartCode = ExpenseUtils.getDefaultChartCode(document);
        for (TemExpense temExpense : expenses) {
            if (!(temExpense instanceof ImportedExpense)) continue;
            ImportedExpense expense = (ImportedExpense)temExpense;
            if (expense.getExpenseDetails() != null && expense.getExpenseDetails().size() > 0) {
                for (ImportedExpense importedExpense : expense.getExpenseDetails()) {
                    if (importedExpense.getExpenseParentId() == null || importedExpense.getCardType() != null) continue;
                    importedExpense.setCardType(expense.getCardType());
                }
                this.calculateDistributionTotals(document, distributionMap, expense.getExpenseDetails());
                continue;
            }
            if (expense.getCardType() == null || expense.getCardType().equals("CTS") || expense.getNonReimbursable().booleanValue()) continue;
            expense.refreshReferenceObject("expenseTypeObjectCode");
            ExpenseTypeObjectCode code = ((TravelExpenseService)SpringContext.getBean(TravelExpenseService.class)).getExpenseType(expense.getExpenseTypeCode(), document.getFinancialDocumentTypeCode(), document.getTripTypeCode(), document.getTraveler().getTravelerTypeCode());
            expense.setTravelExpenseTypeCode(code);
            String string = expense.getExpenseTypeObjectCode() != null ? expense.getExpenseTypeObjectCode().getFinancialObjectCode() : null;
            LOG.debug((Object)("Refreshed importedExpense with expense type code " + (Object)((Object)expense.getExpenseTypeObjectCode()) + " and financialObjectCode " + string));
            ObjectCode objCode = this.getObjectCodeService().getByPrimaryIdForCurrentYear(defaultChartCode, string);
            if (objCode == null || code == null || code.getExpenseType().isPrepaidExpense()) continue;
            AccountingDistribution distribution = null;
            String key = objCode.getCode() + "-" + expense.getCardType();
            if (distributionMap.containsKey(key)) {
                distributionMap.get(key).setSubTotal((KualiDecimal)distributionMap.get(key).getSubTotal().add((AbstractKualiDecimal)expense.getConvertedAmount()));
                distributionMap.get(key).setRemainingAmount((KualiDecimal)distributionMap.get(key).getRemainingAmount().add((AbstractKualiDecimal)expense.getConvertedAmount()));
                continue;
            }
            distribution = new AccountingDistribution();
            distribution.setObjectCode(objCode.getCode());
            distribution.setObjectCodeName(objCode.getName());
            distribution.setCardType(expense.getCardType());
            distribution.setRemainingAmount(expense.getConvertedAmount());
            distribution.setSubTotal(expense.getConvertedAmount());
            distributionMap.put(key, distribution);
        }
    }

    @Override
    public List<? extends TemExpense> getExpenseDetails(TravelDocument document) {
        List<ImportedExpense> importedExpenses = document.getImportedExpenses();
        HashSet<Long> importedHistoricalExpenseIds = new HashSet<Long>();
        ArrayList<TemExpense> corporateCardExpenses = new ArrayList<TemExpense>();
        for (ImportedExpense expense : importedExpenses) {
            if (!StringUtils.equals((String)expense.getCardType(), (String)"CORP")) continue;
            corporateCardExpenses.add(expense);
            importedHistoricalExpenseIds.add(expense.getHistoricalTravelExpenseId());
        }
        List<HistoricalTravelExpense> hungExpenses = document.getHistoricalTravelExpenses();
        for (HistoricalTravelExpense expense : hungExpenses) {
            if (!StringUtils.equals((String)expense.getCreditCardAgency().getTravelCardTypeCode(), (String)"CORP") || importedHistoricalExpenseIds.contains(expense.getId())) continue;
            corporateCardExpenses.add(new HistoricalExpenseAsTemExpenseWrapper(expense));
        }
        return corporateCardExpenses;
    }

    @Override
    public boolean validateExpenseCalculation(TemExpense expense) {
        return expense instanceof ImportedExpense && ((ImportedExpense)expense).getCardType() != null && !StringUtils.defaultString((String)((ImportedExpense)expense).getCardType()).equals("CTS") || expense instanceof HistoricalExpenseAsTemExpenseWrapper && !StringUtils.equals((String)((HistoricalExpenseAsTemExpenseWrapper)expense).getCardType(), (String)"CTS");
    }

    @Override
    public void processExpense(TravelDocument travelDocument, GeneralLedgerPendingEntrySequenceHelper sequenceHelper) {
        for (TemSourceAccountingLine line : travelDocument.getSourceAccountingLines()) {
            if (!this.creditCardAgencyService.getCorpCreditCardAgencyCodeList().contains(line.getCardType())) continue;
            this.importedExpensePendingEntryService.generateDocumentImportedExpenseGeneralLedgerPendingEntries(travelDocument, (GeneralLedgerPendingEntrySourceDetail)line, sequenceHelper, false, "RCCA");
        }
    }

    @Override
    public void updateExpense(TravelDocument travelDocument) {
        List<HistoricalTravelExpense> historicalTravelExpenses = travelDocument.getHistoricalTravelExpenses();
        for (HistoricalTravelExpense historicalTravelExpense : historicalTravelExpenses) {
            if (!historicalTravelExpense.isCreditCardTravelExpense() || !StringUtils.isBlank((String)historicalTravelExpense.getReconciled()) && !StringUtils.equals((String)historicalTravelExpense.getReconciled(), (String)"N")) continue;
            long time = new java.util.Date().getTime();
            historicalTravelExpense.setReconciliationDate(new Date(time));
            historicalTravelExpense.setReconciled("R");
        }
        this.getBusinessObjectService().save(historicalTravelExpenses);
    }

    public void setCreditCardAgencyService(CreditCardAgencyService creditCardAgencyService) {
        this.creditCardAgencyService = creditCardAgencyService;
    }

    public void setImportedExpensePendingEntryService(ImportedExpensePendingEntryService importedExpensePendingEntryService) {
        this.importedExpensePendingEntryService = importedExpensePendingEntryService;
    }
}

