# expand-brackets [![NPM version](https://badge.fury.io/js/expand-brackets.svg)](http://badge.fury.io/js/expand-brackets)

> Expand POSIX bracket expressions (character classes) in glob patterns.

Install with [npm](https://www.npmjs.com/)

```sh
$ npm i expand-brackets --save
```

## Usage

```js
var brackets = require('expand-brackets');

brackets('[![:lower:]]');
//=> '[^a-z]'
```

## .isMatch

Return true if the given string matches the bracket expression:

```js
brackets.isMatch('A', '[![:lower:]]');
//=> true

brackets.isMatch('a', '[![:lower:]]');
//=> false
```

## .makeRe

Make a regular expression from a bracket expression:

```js
brackets.makeRe('[![:lower:]]');
//=> /[^a-z]/
```

The following named POSIX bracket expressions are supported:

* `[:alnum:]`: Alphanumeric characters (`a-zA-Z0-9]`)
* `[:alpha:]`: Alphabetic characters (`a-zA-Z]`)
* `[:blank:]`: Space and tab (`[ t]`)
* `[:digit:]`: Digits (`[0-9]`)
* `[:lower:]`: Lowercase letters (`[a-z]`)
* `[:punct:]`: Punctuation and symbols. (`[!"#$%&'()*+, -./:;<=>?@ [\]^_``{|}~]`)
* `[:upper:]`: Uppercase letters (`[A-Z]`)
* `[:word:]`: Word characters (letters, numbers and underscores) (`[A-Za-z0-9_]`)
* `[:xdigit:]`: Hexadecimal digits (`[A-Fa-f0-9]`)

Collating sequences are not supported.

## Related projects

* [extglob](https://github.com/jonschlinkert/extglob): Convert extended globs to regex-compatible strings. Add (almost) the expressive power of regular expressions to… [more](https://github.com/jonschlinkert/extglob)
* [is-glob](https://github.com/jonschlinkert/is-glob): Returns `true` if the given string looks like a glob pattern.
* [is-extglob](https://github.com/jonschlinkert/is-extglob): Returns true if a string has an extglob.
* [is-posix-bracket](https://github.com/jonschlinkert/is-posix-bracket): Returns true if the given string is a POSIX bracket expression (POSIX character class).
* [micromatch](https://github.com/jonschlinkert/micromatch): Glob matching for javascript/node.js. A drop-in replacement and faster alternative to minimatch and multimatch. Just… [more](https://github.com/jonschlinkert/micromatch)

## Running tests

Install dev dependencies:

```sh
$ npm i -d && npm test
```

## Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](https://github.com/jonschlinkert/expand-brackets/issues/new)

## Author

**Jon Schlinkert**

+ [github/jonschlinkert](https://github.com/jonschlinkert)
+ [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

## License

Copyright © 2015 Jon Schlinkert
Released under the MIT license.

***

_This file was generated by [verb-cli](https://github.com/assemble/verb-cli) on August 01, 2015._