/*
	MIT License http://www.opensource.org/licenses/mit-license.php
	Author Tobias Koppers @sokra
*/
var base64VLQ = require("./base64-vlq");
var SourceNode = require("./SourceNode");
var CodeNode = require("./CodeNode");
var SourceListMap = require("./SourceListMap");

module.exports = function fromStringWithSourceMap(code, map) {
	var sources = map.sources;
	var sourcesContent = map.sourcesContent;
	var mappings = map.mappings.split(";");
	var lines = code.split("\n");
	var nodes = [];
	var currentNode = null;
	var currentLine = 1;
	var currentSourceIdx = 0;
	var currentSourceNodeLine;
	mappings.forEach(function(mapping, idx) {
		var line = lines[idx];
		if(idx !== lines.length - 1) line += "\n";
		if(!mapping)
			return addCode(line);
		mapping = { value: 0, rest: mapping };
		var lineAdded = false;
		while(mapping.rest)
			lineAdded = processMapping(mapping, line, lineAdded) || lineAdded;
		if(!lineAdded)
			addCode(line);
	});
	if(mappings.length < lines.length) {
		var idx = mappings.length;
		while(!lines[idx].trim() && idx < lines.length-1) {
			addCode(lines[idx] + "\n");
			idx++;
		}
		addCode(lines.slice(idx).join("\n"));
	}
	return new SourceListMap(nodes);
	function processMapping(mapping, line, ignore) {
		if(mapping.rest && mapping.rest[0] !== ",") {
			base64VLQ.decode(mapping.rest, mapping);
		}
		if(!mapping.rest)
			return false;
		if(mapping.rest[0] === ",") {
			mapping.rest = mapping.rest.substr(1);
			return false;
		}

		base64VLQ.decode(mapping.rest, mapping);
		var sourceIdx = mapping.value + currentSourceIdx;
		currentSourceIdx = sourceIdx;

		if(mapping.rest && mapping.rest[0] !== ",") {
			base64VLQ.decode(mapping.rest, mapping);
			var linePosition = mapping.value + currentLine;
			currentLine = linePosition;
		} else {
			var linePosition = currentLine;
		}

		if(mapping.rest && mapping.rest[0] === ",") {
			mapping.rest = mapping.rest.substr(1);
		}

		if(!ignore) {
			addSource(line, sources ? sources[sourceIdx] : null, sourcesContent ? sourcesContent[sourceIdx] : null, linePosition)
			return true;
		}
	}
	function addCode(generatedCode) {
		if(currentNode && currentNode instanceof CodeNode) {
			currentNode.addGeneratedCode(generatedCode);
		} else if(currentNode && currentNode instanceof SourceNode && !generatedCode.trim()) {
			currentNode.generatedCode += generatedCode;
			currentSourceNodeLine++;
		} else {
			currentNode = new CodeNode(generatedCode);
			nodes.push(currentNode);
		}
	}
	function addSource(generatedCode, source, originalSource, linePosition) {
		if(currentNode && currentNode instanceof SourceNode &&
			currentNode.source === source &&
			currentSourceNodeLine === linePosition
		) {
			currentNode.generatedCode += generatedCode;
			currentSourceNodeLine++;
		} else {
			currentNode = new SourceNode(generatedCode, source, originalSource, linePosition);
			currentSourceNodeLine = linePosition + 1;
			nodes.push(currentNode);
		}
	}
};
