<%--
   - The Kuali Financial System, a comprehensive financial management system for higher education.
   - 
   - Copyright 2005-2014 The Kuali Foundation
   - 
   - This program is free software: you can redistribute it and/or modify
   - it under the terms of the GNU Affero General Public License as
   - published by the Free Software Foundation, either version 3 of the
   - License, or (at your option) any later version.
   - 
   - This program is distributed in the hope that it will be useful,
   - but WITHOUT ANY WARRANTY; without even the implied warranty of
   - MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   - GNU Affero General Public License for more details.
   - 
   - You should have received a copy of the GNU Affero General Public License
   - along with this program.  If not, see <http://www.gnu.org/licenses/>.
--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<c:set var="csfTrackerAttributes"
       value="${DataDictionary.BudgetConstructionCalculatedSalaryFoundationTracker.attributes}"/>

<%--NOTE: DO NOT FORMAT THIS FILE, DISPLAY:COLUMN WILL NOT WORK CORRECTLY IF IT CONTAINS LINE BREAKS --%>
<c:set var="headerMenu" value=""/>
<c:if test="${KualiForm.suppressActions!=true}">
    <c:set var="headerMenu" value="${KualiForm.lookupable.createNewUrl}   ${KualiForm.lookupable.htmlMenuBar}"/>
</c:if>

<c:set var="numberOfColumns" value="${KualiForm.numColumns}"/>

<kul:page lookup="true" showDocumentInfo="false"
          headerMenuBar="${headerMenu}"
          headerTitle="Lookup" docTitle="" transactionalDocument="false"
          htmlFormAction="budgetTempListLookup">

    <SCRIPT type="text/javascript">
        var kualiForm = document.forms['KualiForm'];
        var kualiElements = kualiForm.elements;
    </SCRIPT>

    <div class="headerarea-small" id="headerarea-small">
        <h1><c:out value="${KualiForm.lookupable.title}"/><kul:help
                resourceKey="lookupHelpText" altText="lookup help"/></h1>
    </div>
    <kul:enterKey methodToCall="search"/>

    <html-el:hidden name="KualiForm" property="backLocation"/>
    <html-el:hidden name="KualiForm" property="formKey"/>
    <html-el:hidden name="KualiForm" property="lookupableImplServiceName"/>
    <html-el:hidden name="KualiForm" property="businessObjectClassName"/>
    <html-el:hidden name="KualiForm" property="conversionFields"/>
    <html-el:hidden name="KualiForm" property="hideReturnLink"/>
    <html-el:hidden name="KualiForm" property="suppressActions"/>
    <html-el:hidden name="KualiForm" property="multipleValues"/>
    <html-el:hidden name="KualiForm" property="lookupAnchor"/>
    <html-el:hidden name="KualiForm" property="readOnlyFields"/>
    <html-el:hidden name="KualiForm" property="referencesToRefresh"/>
    <html-el:hidden name="KualiForm" property="reportMode"/>
    <html-el:hidden name="KualiForm" property="currentPointOfViewKeyCode"/>
    <html-el:hidden name="KualiForm" property="buildControlList"/>
    <html-el:hidden name="KualiForm" property="reportConsolidation"/>
    <html-el:hidden name="KualiForm" property="tempListLookupMode"/>
    <html-el:hidden name="KualiForm" property="forceToAccountListScreen"/>
    <html-el:hidden name="KualiForm" property="showSalaryByPositionAction"/>
    <html-el:hidden name="KualiForm" property="addLine"/>
    <html-el:hidden name="KualiForm" property="showSalaryByIncumbentAction"/>
    <html-el:hidden name="KualiForm" property="budgetByAccountMode"/>
    <html-el:hidden name="KualiForm" property="mainWindow"/>

    <%-- only need hidden fiscal year when used inside BC --%>
    <c:if test="${KualiForm.tempListLookupMode != BCConstants.TempListLookupMode.DEFAULT_LOOKUP_MODE}">
        <html-el:hidden name="KualiForm" property="universityFiscalYear"/>
    </c:if>

    <c:forEach items="${KualiForm.extraButtons}" varStatus="status">
        <html-el:hidden name="KualiForm" property="extraButtons[${status.index}].extraButtonSource"/>
        <html-el:hidden name="KualiForm" property="extraButtons[${status.index}].extraButtonParams"/>
    </c:forEach>

    <table width="100%">
        <tr>
            <td>
                <kul:errors errorTitle="Errors Found:"/>
                <kul:messages/>

                <c:forEach items="${KualiForm.messages}" var="message">
                    ${message}
                </c:forEach>
            </td>
        </tr>
    </table>

    <table width="100%">
        <tr>
            <td>
                <div id="lookup" align="center">

                    <c:if test="${numberOfColumns > 1}">
                        <c:set var="tableClass" value="multi-column-table"/>
                    </c:if>

                    <table align="center" class="${tableClass}">
                        <c:set var="FormName" value="KualiForm" scope="request"/>
                        <c:set var="FieldRows" value="${KualiForm.lookupable.rows}" scope="request"/>
                        <c:set var="ActionName" value="budgetTempListLookup.do" scope="request"/>
                        <c:set var="IsLookupDisplay" value="true" scope="request"/>
                        <c:set var="cellWidth" value="50%" scope="request"/>

                        <kul:rowDisplay rows="${FieldRows}" skipTheOldNewBar="true"
                                        numberOfColumns="${numberOfColumns}"/>


                        <tr align=center>
                            <td height="30" colspan=2 class="infoline">
                                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.ACCOUNT_SELECT_ABOVE_POV}">
                                    <html:submit
                                            property="methodToCall.submitReport"
                                            value="Submit"
                                            styleClass="btn btn-default"
                                            alt="submit"
                                            title="submit"
                                            onblur="formHasAlreadyBeenSubmitted = false"/>
                                </c:if>
                                <c:if test="${KualiForm.tempListLookupMode != BCConstants.TempListLookupMode.SHOW_BENEFITS}">
                                    <html:submit
                                            property="methodToCall.search" value="Search"
                                            styleClass="btn btn-default"
                                            alt="Search" title="Search"/>
                                    <html:submit
                                            property="methodToCall.clearValues" value="Clear"
                                            styleClass="btn btn-default"
                                            alt="Clear" title="Clear"/>
                                </c:if>
                                <c:choose>
                                    <c:when test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.CSF_TRACKER_POSITION_LOOKUP}">
                                        <html:submit
                                                property="methodToCall.refresh"
                                                value="Cancel"
                                                styleClass="tinybutton"
                                                onclick="window.close()"
                                                alt="cancel"
                                                title="cancel"/>
                                    </c:when>
                                    <c:otherwise>
                                        <html:submit
                                                property="methodToCall.cancel" value="Cancel"
                                                styleClass="tinybutton btn btn-default"
                                                alt="Cancel" title="Cancel"/>
                                    </c:otherwise>
                                </c:choose>
                                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.POSITION_SELECT}">
                                    <html:submit
                                            property="methodToCall.performExtendedPositionSearch"
                                            value="Extended"
                                            styleClass="btn btn-default"
                                            alt="perform extended search"
                                            title="perform extended search"/>
                                </c:if>

                                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.INTENDED_INCUMBENT_SELECT}">
                                    <html:submit
                                            property="methodToCall.performExtendedIncumbentSearch"
                                            value="Extended"
                                            styleClass="btn btn-default"
                                            alt="perform extended search"
                                            title="perform extended search"/>
                                </c:if>

                                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.BUDGET_POSITION_LOOKUP}">
                                    <c:if test="${KualiForm.getNewPositionEnabled}">
                                        <html:submit
                                                property="methodToCall.getNewPosition"
                                                value="Get New"
                                                styleClass="btn btn-default"
                                                alt="get new position"
                                                title="get new position"/>
                                    </c:if>
                                    <c:if test="${KualiForm.addLine}">
                                        <html-el:hidden name="KualiForm" property="chartOfAccountsCode"/>
                                        <html-el:hidden name="KualiForm" property="accountNumber"/>
                                        <html-el:hidden name="KualiForm" property="subAccountNumber"/>
                                        <html-el:hidden name="KualiForm" property="financialObjectCode"/>
                                        <html-el:hidden name="KualiForm" property="financialSubObjectCode"/>
                                    </c:if>
                                </c:if>

                                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.INTENDED_INCUMBENT}">
                                    <c:if test="${KualiForm.getNewIncumbentEnabled}">
                                        <html:submit
                                                property="methodToCall.getNewIncumbent"
                                                value="Get New"
                                                styleClass="btn btn-default"
                                                alt="get new incumbent"
                                                title="get new incumbent"/>
                                    </c:if>
                                    <c:if test="${KualiForm.addLine}">
                                        <html-el:hidden name="KualiForm" property="chartOfAccountsCode"/>
                                        <html-el:hidden name="KualiForm" property="accountNumber"/>
                                        <html-el:hidden name="KualiForm" property="subAccountNumber"/>
                                        <html-el:hidden name="KualiForm" property="financialObjectCode"/>
                                        <html-el:hidden name="KualiForm" property="financialSubObjectCode"/>
                                    </c:if>
                                </c:if>

                                <!-- Optional extra buttons -->
                                <c:forEach items="${KualiForm.extraButtons}" var="extraButton" varStatus="status">
                                <c:if test="${!empty extraButton.extraButtonSource && !empty extraButton.extraButtonParams}">
                                <a href='<c:out value="${KualiForm.backLocation}?methodToCall=refresh&refreshCaller=kualiLookupable&docFormKey=${KualiForm.formKey}&anchor=${KualiForm.lookupAnchor}" /><c:out value="${extraButton.extraButtonParams}" />'
                                   title='<c:out value="${extraButton.extraAltText}" />'>
                                    <span class="tinybutton btn btn-default"><c:out
                                            value="${extraButton.extraAltText}"/></span>
                                    </c:if>
                                    </c:forEach>
                                    <c:if test="${KualiForm.multipleValues }">
                                    <a href='<c:out value="${KualiForm.backLocation}?methodToCall=refresh&docFormKey=${KualiForm.formKey}&anchor=${KualiForm.lookupAnchor}" />'
                                       title="Return with No Value">
                                        <span class="tinybutton btn btn-default">Return with No Value</span>
                                    </a>
                                    <a href='<c:out value="${KualiForm.backLocation}?methodToCall=refresh&docFormKey=${KualiForm.formKey}&refreshCaller=multipleValues&searchResultKey=${searchResultKey}&searchResultDataKey=${searchResultDataKey}&anchor=${KualiForm.lookupAnchor}"/>'
                                       title="Return These">
                                        <span class="tinybutton btn btn-default">Return These</span>
                                    </a>
                                    </c:if>
                            </td>
                        </tr>
                    </table>
                </div>

                <c:if test="${KualiForm.tempListLookupMode == BCConstants.TempListLookupMode.CSF_TRACKER_POSITION_LOOKUP}">
                    <table bgcolor="#C0C0C0" cellpadding="30">
                        <tr>
                            <td>
                                <!-- hiddens for search criteria merging -->
                                <html-el:hidden name="KualiForm" property="financialObjectCode"/>
                                <html-el:hidden name="KualiForm" property="financialSubObjectCode"/>

                                <b><kul:htmlAttributeLabel
                                        attributeEntry="${csfTrackerAttributes.universityFiscalYear}"/></b>
                                <kul:htmlControlAttribute property="universityFiscalYear" readOnly="true"
                                                          attributeEntry="${csfTrackerAttributes.universityFiscalYear}"/>
                            </td>
                            <td>
                                <b><kul:htmlAttributeLabel
                                        attributeEntry="${csfTrackerAttributes.chartOfAccountsCode}"/></b>
                                <kul:htmlControlAttribute property="chartOfAccountsCode" readOnly="true"
                                                          attributeEntry="${csfTrackerAttributes.chartOfAccountsCode}"/>
                            </td>
                            <td>
                                <b><kul:htmlAttributeLabel attributeEntry="${csfTrackerAttributes.accountNumber}"/></b>
                                <kul:htmlControlAttribute property="accountNumber" readOnly="true"
                                                          attributeEntry="${csfTrackerAttributes.accountNumber}"/>
                            </td>
                            <td>
                                <b><kul:htmlAttributeLabel
                                        attributeEntry="${csfTrackerAttributes.subAccountNumber}"/></b>
                                <kul:htmlControlAttribute property="subAccountNumber" readOnly="true"
                                                          attributeEntry="${csfTrackerAttributes.subAccountNumber}"/>
                            </td>
                        <tr>
                    </table>
                </c:if>

                <c:if test="${reqSearchResults != null and empty reqSearchResults}">
                    <div class="search-message"><bean-el:message key="error.no.matching.invoice" /></div>
                </c:if>

                <c:if test="${reqSearchResultsActualSize>0}">
                    <c:out value="${reqSearchResultsActualSize}"/> items found. Please refine your search criteria to narrow down your search.
                </c:if>

                <c:if test="${!empty reqSearchResultsActualSize }">
                    <c:if test="${KualiForm.searchUsingOnlyPrimaryKeyValues}">
                        <bean-el:message key="lookup.using.primary.keys" arg0="${KualiForm.primaryKeyFieldLabels}"/>
                    </c:if>

                    <display:table class="datatable-100"
                                   requestURIcontext="false" name="${reqSearchResults}"
                                   id="row" export="true" pagesize="100"
                                   requestURI="budgetTempListLookup.do?methodToCall=viewResults&reqSearchResultsActualSize=${reqSearchResultsActualSize}&searchResultKey=${searchResultKey}&searchUsingOnlyPrimaryKeyValues=${KualiForm.searchUsingOnlyPrimaryKeyValues}">

                        <c:if test="${param['d-16544-e'] == null}">
                            <logic:present name="KualiForm" property="formKey">
                                <c:if
                                        test="${KualiForm.formKey!='' && KualiForm.hideReturnLink!=true && !KualiForm.multipleValues}">
                                    <display:column class="infocell" property="returnUrl" media="html"/>
                                </c:if>
                                <c:if test="${row.actionUrls!='' && KualiForm.suppressActions!=true}">
                                    <display:column class="infocell" property="actionUrls"
                                                    title="Actions" media="html"/>
                                </c:if>
                            </logic:present>
                        </c:if>

                        <c:forEach items="${row.columns}" var="column" varStatus="loopStatus">
                            <c:set var="colClass"
                                   value="${ fn:startsWith(column.formatter, 'org.kuali.rice.core.web.format.CurrencyFormatter') ? 'numbercell' : 'infocell' }"/>
                            <c:choose>
                                <%--NOTE: Check if exporting first, as this should be outputted without extra HTML formatting --%>
                                <c:when test="${param['d-16544-e'] != null}">
                                    <display:column class="${colClass}" sortable="${column.sortable}"
                                                    title="${column.columnTitle}" comparator="${column.comparator}"
                                                    maxLength="${column.maxLength}"><c:out
                                            value="${column.propertyValue}" escapeXml="false"
                                            default=""/></display:column>
                                </c:when>
                                <c:when test="${!empty column.propertyURL}">
                                    <display:column class="${colClass}" sortable="${column.sortable}"
                                                    title="${column.columnTitle}" comparator="${column.comparator}">
                                        <a href="<c:out value="${column.propertyURL}"/>" target="_blank"
                                           title="${column.propertyValue}"><c:out
                                                value="${fn:substring(column.propertyValue, 0, column.maxLength)}"
                                                /><c:if
                                                test="${column.maxLength gt 0 && fn:length(column.propertyValue) gt column.maxLength}">...</c:if></a> &nbsp;
                                    </display:column>
                                </c:when>
                                <%--NOTE: DO NOT FORMAT THIS FILE, DISPLAY:COLUMN WILL NOT WORK CORRECTLY IF IT CONTAINS LINE BREAKS --%>
                                <c:when test="${column.columnTitle == 'Project Code'}">
                                    <display:column class="${colClass}" sortable="${column.sortable}"
                                                    title="${column.columnTitle}" comparator="${column.comparator}"
                                                    maxLength="${column.maxLength}"
                                                    decorator="org.kuali.kfs.kns.web.ui.FormatAwareDecorator">
                                        <div style="white-space: nowrap"><c:out
                                                value="${column.propertyValue}"/>&nbsp;</div>
                                    </display:column>
                                </c:when>
                                <c:otherwise>
                                    <display:column class="${colClass}" sortable="${column.sortable}"
                                                    title="${column.columnTitle}" comparator="${column.comparator}"
                                                    maxLength="${column.maxLength}"
                                                    decorator="org.kuali.kfs.kns.web.ui.FormatAwareDecorator"><c:out
                                            value="${column.propertyValue}"/>&nbsp;</display:column>
                                </c:otherwise>
                            </c:choose>
                        </c:forEach>
                    </display:table>
                </c:if>
            </td>
        </tr>
    </table>

    <kul:stickyLookupButtons/>

</kul:page>
