/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.exception.AuthenticationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.filter.LoginFilterBase;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.rice.core.api.resourceloader.GlobalResourceLoader;
import org.kuali.rice.kim.api.identity.AuthenticationService;

public class ResourceLoginFilter
extends LoginFilterBase {
    private static final Logger LOG = Logger.getLogger(ResourceLoginFilter.class);
    public static final String UNAUTHORIZED_JSON = "[ \"Unauthorized\" ]";

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug((Object)"doFilter() started");
        try {
            String authorizationHeader = request.getHeader("Authorization");
            Optional user = this.getPrincipalNameFromHeader(request, response, authorizationHeader);
            if (!user.isPresent()) {
                this.sendError(response);
                this.removeFromMDC();
                return;
            }
            this.setUserSession(request, (String)user.get());
            this.establishUserSession(request, response);
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IllegalArgumentException | AuthenticationException e) {
            LOG.error((Object)"doFilter() AuthenticationException", e);
            this.sendError(response);
        }
        finally {
            this.removeFromMDC();
        }
    }

    protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession != null) {
            GlobalVariables.setUserSession((UserSession)userSession);
        }
        this.establishSessionCookie(request, response);
        this.establishBackdoorUser(request);
        this.addToMDC(request);
    }

    private Optional<String> getPrincipalNameFromHeader(HttpServletRequest request, HttpServletResponse response, String authorizationHeader) throws IOException {
        if (authorizationHeader == null) {
            return Optional.empty();
        }
        Optional oKey = this.getApiKey(authorizationHeader);
        if (oKey.isPresent()) {
            if (this.getCoreApiKeyAuthenticationService().useCore()) {
                return this.getCoreApiKeyAuthenticationService().getPrincipalIdFromApiKey((String)oKey.get());
            }
            try {
                JwtData data = this.getJwtService().decodeJwt((String)oKey.get());
                return Optional.of(data.getPrincipalName());
            }
            catch (RuntimeException e) {
                LOG.debug((Object)"getPrincipalNameFromHeader() invalid financials token", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private void sendError(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.getWriter().println(UNAUTHORIZED_JSON);
    }

    protected void setUserSession(HttpServletRequest request, String principalName) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession == null || userSession.getActualPerson() == null || !StringUtils.equals((String)userSession.getActualPerson().getPrincipalName(), (String)principalName)) {
            UserSession newUserSession = new UserSession(principalName);
            request.getSession().setAttribute("cf.UserSession", (Object)newUserSession);
        }
    }

    private Optional<String> getApiKey(String authorizationHeader) {
        if (!authorizationHeader.toLowerCase().startsWith("bearer")) {
            LOG.error((Object)"getApiKey() authorization header missing Bearer prefix");
            return Optional.empty();
        }
        String[] split = authorizationHeader.split("\\s+");
        if (split.length != 2) {
            LOG.error((Object)"doFilter() authorization header should be two parts");
            return Optional.empty();
        }
        return Optional.of(split[1]);
    }

    protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
        return (CoreApiKeyAuthenticationService)SpringContext.getBean(CoreApiKeyAuthenticationService.class);
    }

    protected JwtService getJwtService() {
        return (JwtService)SpringContext.getBean(JwtService.class);
    }

    protected AuthenticationService getAuthenticationService() {
        return (AuthenticationService)GlobalResourceLoader.getResourceLoader().getService(new QName("kimAuthenticationService"));
    }
}

