/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.PrintWriter;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.junit.Before;
import org.junit.Test;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.kns.service.CfAuthenticationService;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.kfs.web.filter.ResourceLoginFilter;
import org.kuali.rice.kim.api.identity.AuthenticationService;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class ResourceLoginFilterTest {
    private ResourceLoginFilter cut;
    @Mock
    private HttpServletRequest requestMock;
    @Mock
    private HttpServletResponse responseMock;
    @Mock
    private HttpSession sessionMock;
    @Mock
    private PrintWriter writerMock;
    @Mock
    private FilterChain filterChainMock;
    @Mock
    private AuthenticationService authSvcMock;
    @Mock
    private CfAuthenticationService cfAuthSvcMock;
    @Mock
    private CoreApiKeyAuthenticationService coreApiKeyAuthSvcMock;
    @Mock
    private JwtService jwtSvcMock;
    private boolean userSessionEstablished;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.cut = new ResourceLoginFilter(){

            protected JwtService getJwtService() {
                return ResourceLoginFilterTest.this.jwtSvcMock;
            }

            protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
                return ResourceLoginFilterTest.this.coreApiKeyAuthSvcMock;
            }

            protected boolean isUserSessionEstablished(HttpServletRequest request) {
                return ResourceLoginFilterTest.this.userSessionEstablished;
            }

            protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
            }

            protected void setUserSession(HttpServletRequest request, String principalName) {
            }

            protected AuthenticationService getAuthenticationService() {
                return ResourceLoginFilterTest.this.authSvcMock;
            }

            protected CfAuthenticationService getCfAuthenticationService() {
                return ResourceLoginFilterTest.this.cfAuthSvcMock;
            }
        };
        this.userSessionEstablished = false;
    }

    @Test
    public void notInSession() throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void notInSessionOrRequest() throws Exception {
        this.userSessionEstablished = false;
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void inSession() throws Exception {
        this.userSessionEstablished = true;
        UserSession userSession = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSession.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)this.sessionMock.getAttribute("cf.UserSession")).thenReturn((Object)userSession);
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn(null);
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void inSessionEmptyHeader() throws Exception {
        this.userSessionEstablished = true;
        UserSession userSession = (UserSession)Mockito.mock(UserSession.class);
        Mockito.when((Object)userSession.getPrincipalName()).thenReturn((Object)"SomeUser");
        Mockito.when((Object)this.sessionMock.getAttribute("cf.UserSession")).thenReturn((Object)userSession);
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"");
        Mockito.when((Object)this.requestMock.getSession()).thenReturn((Object)this.sessionMock);
        this.expectErrorResponse();
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void blankAuthHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"");
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void noBearerHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"XXX");
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void onlyBearerHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer");
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void blankKeyHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer ");
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void nonCoreBadHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("BAD")).thenThrow(new Throwable[]{new RuntimeException("Error")});
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void nonCoreGoodHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)false);
        JwtData data = new JwtData("user", 1000);
        Mockito.when((Object)this.jwtSvcMock.decodeJwt("GOOD")).thenReturn((Object)data);
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((JwtService)Mockito.verify((Object)this.jwtSvcMock)).decodeJwt(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.jwtSvcMock});
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
    }

    @Test
    public void coreBadHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer BAD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("BAD")).thenReturn(Optional.empty());
        this.expectErrorResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void coreGoodHeader() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD")).thenReturn(Optional.of("user"));
        this.filterChainMock.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.VALID_AUTHENTICATION);
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        ((FilterChain)Mockito.verify((Object)this.filterChainMock, (VerificationMode)Mockito.times((int)2))).doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    @Test
    public void coreGoodHeaderInactiveUser() throws Exception {
        Mockito.when((Object)this.requestMock.getHeader("Authorization")).thenReturn((Object)"Bearer GOOD");
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.useCore()).thenReturn((Object)true);
        Mockito.when((Object)this.coreApiKeyAuthSvcMock.getPrincipalIdFromApiKey("GOOD")).thenReturn(Optional.of("user"));
        Mockito.when((Object)this.cfAuthSvcMock.validatePrincipalName(ArgumentMatchers.anyString())).thenReturn((Object)AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN);
        this.expectForbiddenResponse();
        this.cut.doFilter((ServletRequest)this.requestMock, (ServletResponse)this.responseMock, this.filterChainMock);
        ((HttpServletRequest)Mockito.verify((Object)this.requestMock)).getHeader(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.requestMock});
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).useCore();
        ((CoreApiKeyAuthenticationService)Mockito.verify((Object)this.coreApiKeyAuthSvcMock)).getPrincipalIdFromApiKey(ArgumentMatchers.anyString());
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.coreApiKeyAuthSvcMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.filterChainMock});
        Mockito.verifyZeroInteractions((Object[])new Object[]{this.jwtSvcMock});
    }

    private void expectErrorResponse() throws Exception {
        this.responseMock.setStatus(401);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Unauthorized\" ]");
    }

    private void expectForbiddenResponse() throws Exception {
        this.responseMock.setStatus(403);
        Mockito.when((Object)this.responseMock.getWriter()).thenReturn((Object)this.writerMock);
        this.writerMock.println("[ \"Forbidden\" ]");
    }
}

