<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2018 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="defaultTabHide" type="java.lang.Boolean" required="false" description="Show tab contents indicator" %>
<c:set var="equipAttributes" value="${DataDictionary.EquipmentLoanOrReturnDocument.attributes}"/>
<c:set var="readOnly" value="${!KualiForm.documentActions[Constants.KUALI_ACTION_CAN_EDIT]}"/>
<c:set var="displayNewLoanTab" value="${KualiForm.editingMode['displayNewLoanTab']}" scope="request"/>
<c:set var="displayReturnLoanFieldsReadOnly" value="${KualiForm.editingMode['displayReturnLoanFieldsReadOnly']}" scope="request"/>

<kul:tab tabTitle="Equipment Loans" defaultOpen="true" tabErrorKey="document.borrowerUniversalIdentifier,document.borrowerPerson.principalName,document.loanDate,document.expectedReturnDate,document.loanReturnDate">
    <div class="tab-container" align="center">
        <table class="standard side-margins">
            <tr>
                <td colspan="4" class="tab-subhead"><h3>Equipment Loan Information</h3></td>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.borrowerUniversalIdentifier}"/></th>
                <c:choose>
                    <c:when test="${!empty KualiForm.document.borrowerPerson.principalName and !displayNewLoanTab}">
                        <td class="grid" width="25%"><c:out value="${KualiForm.document.borrowerPerson.principalName}"/>
                    </c:when>
                    <c:otherwise>
                        <td class="grid" width="25%">
                            <kul:checkErrors keyMatch="document.borrowerPerson.principalName,document.borrowerUniversalIdentifier"/>
                            <kul:user userIdFieldName="document.borrowerPerson.principalName"
                                      userId="${KualiForm.document.borrowerPerson.principalName}"
                                      universalIdFieldName="document.borrowerUniversalIdentifier"
                                      universalId="${KualiForm.document.borrowerUniversalIdentifier}"
                                      userNameFieldName="document.borrowerPerson.name" label="User"
                                      userName="${KualiForm.document.borrowerPerson.name}"
                                      lookupParameters="document.borrowerPerson.principalName:principalName"
                                      fieldConversions="principalName:document.borrowerPerson.principalName,principalId:document.borrowerUniversalIdentifier,name:document.borrowerPerson.name"
                                      hasErrors="${hasErrors}" readOnly="${readOnly}"/>
                        </td>
                    </c:otherwise>
                </c:choose>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.loanDate}"/></th>
                <c:choose>
                    <c:when test="${readOnly or !displayNewLoanTab}">
                        <td class="grid" width="25%"><kul:htmlControlAttribute attributeEntry="${equipAttributes.loanDate}" property="document.loanDate" readOnly="true"/>
                    </c:when>
                    <c:otherwise>
                        <td class="grid" width="25%"><kul:dateInput attributeEntry="${equipAttributes.loanDate}" property="document.loanDate"/></td>
                    </c:otherwise>
                </c:choose>
            </tr>
            <tr>
                <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.expectedReturnDate}"/></th>
                <c:choose>
                    <c:when test="${readOnly or displayReturnLoanFieldsReadOnly}">
                        <td class="grid" width="25%"><kul:htmlControlAttribute attributeEntry="${equipAttributes.expectedReturnDate}" property="document.expectedReturnDate" readOnly="true"/>
                    </c:when>
                    <c:otherwise>
                        <td class="grid" width="25%"><kul:dateInput attributeEntry="${equipAttributes.expectedReturnDate}" property="document.expectedReturnDate"/></td>
                    </c:otherwise>
                </c:choose>
                <c:choose>
                    <c:when test="${displayNewLoanTab or (empty KualiForm.document.loanReturnDate)}">
                        <th class="grid right" width="25%"colspan="2"></th>
                    </c:when>
                    <c:otherwise>
                        <th class="grid right" width="25%"><kul:htmlAttributeLabel attributeEntry="${equipAttributes.loanReturnDate}"/></th>
                        <c:choose>
                            <c:when test="${readOnly}">
                                <td class="grid" width="25%"><kul:htmlControlAttribute attributeEntry="${equipAttributes.loanReturnDate}" property="document.loanReturnDate" readOnly="true"/>
                            </c:when>
                            <c:otherwise>
                                <td class="grid" width="25%"><kul:dateInput attributeEntry="${equipAttributes.loanReturnDate}" property="document.loanReturnDate"/></td>
                            </c:otherwise>
                        </c:choose>
                    </c:otherwise>
                </c:choose>
            </tr>
        </table>
    </div>
</kul:tab>
