/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.rice.kew.service.impl;

import org.apache.commons.lang3.StringUtils;
import org.kuali.rice.kim.api.KimConstants;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.kfs.kim.framework.responsibility.ResponsibilityTypeService;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class ReviewResponsibilityTypeServiceImpl extends DocumentTypeResponsibilityTypeServiceImpl implements
        ResponsibilityTypeService {

    {
        exactMatchStringAttributeName = KimConstants.AttributeConstants.ROUTE_NODE_NAME;
    }

    @Override
    protected List<String> getRequiredAttributes() {
        final List<String> attrs = new ArrayList<>(super.getRequiredAttributes());
        attrs.add(KimConstants.AttributeConstants.ROUTE_NODE_NAME);
        return Collections.unmodifiableList(attrs);
    }

    @Override
    protected List<Responsibility> performResponsibilityMatches(
            Map<String, String> requestedDetails,
            List<Responsibility> responsibilitiesList) {
        // get the base responsibility matches based on the route level and document type
        List<Responsibility> baseMatches = super.performResponsibilityMatches(requestedDetails,
                responsibilitiesList);
        // now, if any of the responsibilities have the "qualifierResolverProvidedIdentifier" detail property
        // perform an exact match on the property with the requested details if the property does not match or does
        // not exist in the requestedDetails, remove the responsibility from the list
        Iterator<Responsibility> respIter = baseMatches.iterator();
        while (respIter.hasNext()) {
            Map<String, String> respDetails = respIter.next().getAttributes();
            if (respDetails.containsKey(KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER)
                    && StringUtils.isNotBlank(respDetails.get(
                    KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER))) {
                if (!requestedDetails
                            .containsKey(KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER)
                        || !StringUtils.equals(respDetails.get(
                            KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER),
                        requestedDetails.get(
                                KimConstants.AttributeConstants.QUALIFIER_RESOLVER_PROVIDED_IDENTIFIER))) {
                    respIter.remove();
                }
            }
        }
        return baseMatches;
    }
}
