/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2020 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package org.kuali.rice.kew.service.impl;

import org.kuali.rice.kew.api.KewApiServiceLocator;
import org.kuali.rice.kew.api.doctype.DocumentTypeService;
import org.kuali.kfs.kim.api.KimConstants;
import org.kuali.rice.kim.api.responsibility.Responsibility;
import org.kuali.kfs.kim.framework.responsibility.ResponsibilityTypeService;
import org.kuali.kfs.kns.kim.responsibility.KimResponsibilityTypeServiceBase;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author Kuali Rice Team (rice.collab@kuali.org)
 */
public class DocumentTypeResponsibilityTypeServiceImpl extends
        KimResponsibilityTypeServiceBase implements ResponsibilityTypeService {
    DocumentTypeService documentTypeService;
    protected String exactMatchStringAttributeName;

    @Override
    protected List<String> getRequiredAttributes() {
        final List<String> attrs = new ArrayList<String>(super.getRequiredAttributes());
        attrs.add(KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME);
        return Collections.unmodifiableList(attrs);
    }

    @Override
    protected boolean isCheckRequiredAttributes() {
        return true;
    }

    @Override
    protected List<Responsibility> performResponsibilityMatches(
            Map<String, String> requestedDetails,
            List<Responsibility> responsibilitiesList) {
        Map<String, List<Responsibility>> potentialDocumentTypeMatches = new HashMap<String, List<Responsibility>>();
        for (Responsibility responsibility : responsibilitiesList) {
            if ((exactMatchStringAttributeName == null)
                    || responsibility.getAttributes().get(exactMatchStringAttributeName)
                            .equals(requestedDetails.get(exactMatchStringAttributeName))) {
                if (!potentialDocumentTypeMatches.containsKey(responsibility
                        .getAttributes().get(KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME))) {
                    potentialDocumentTypeMatches.put(
                            responsibility.getAttributes().get(
                                    KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME),
                            new ArrayList<Responsibility>());
                }
                potentialDocumentTypeMatches.get(
                        responsibility.getAttributes().get(
                                KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME)).add(
                        responsibility);
            }
        }
        List<Responsibility> matchingResponsibilities = new ArrayList<Responsibility>();
        if (potentialDocumentTypeMatches.containsKey(requestedDetails
                .get(KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME))) {
            matchingResponsibilities
                    .addAll(potentialDocumentTypeMatches.get(requestedDetails
                            .get(KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME)));
        } else {
            String closestParentDocumentTypeName = getClosestParentDocumentTypeName(getDocumentTypeService()
                    .getDocumentTypeByName(requestedDetails.get(KimConstants.AttributeConstants.DOCUMENT_TYPE_NAME)),
                    potentialDocumentTypeMatches.keySet());
            if (closestParentDocumentTypeName != null) {
                matchingResponsibilities.addAll(potentialDocumentTypeMatches
                        .get(closestParentDocumentTypeName));
            }
        }
        return matchingResponsibilities;
    }

    public DocumentTypeService getDocumentTypeService() {
        if (documentTypeService == null) {
            documentTypeService = KewApiServiceLocator.getDocumentTypeService();
        }
        return this.documentTypeService;
    }
}
