/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web.filter;

import java.io.IOException;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.kuali.kfs.kns.bo.AuthenticationValidationResponse;
import org.kuali.kfs.krad.UserSession;
import org.kuali.kfs.krad.exception.AuthenticationException;
import org.kuali.kfs.krad.util.GlobalVariables;
import org.kuali.kfs.krad.util.KRADUtils;
import org.kuali.kfs.krad.web.filter.LoginFilterBase;
import org.kuali.kfs.sys.businessobject.JwtData;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.sys.service.CoreApiKeyAuthenticationService;
import org.kuali.kfs.sys.service.JwtService;
import org.kuali.kfs.sys.util.BearerTokenContext;

/*
 * Exception performing whole class analysis ignored.
 */
public class ResourceLoginFilter
extends LoginFilterBase {
    private static final Logger LOG = LogManager.getLogger();
    static final String UNAUTHORIZED_JSON = "[ \"Unauthorized\" ]";
    static final String FORBIDDEN_JSON = "[ \"Forbidden\" ]";
    private static final Set<String> UNAUTHENTICATED_APIS = Set.of("/health/check", "/health/integrity");

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.doFilter((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        LOG.debug("doFilter() started");
        try {
            if (ResourceLoginFilter.pathRequiresAuthentication((HttpServletRequest)request)) {
                Optional user = this.getPrincipalNameFromRequest(request);
                if (user.isEmpty()) {
                    ResourceLoginFilter.sendError((HttpServletResponse)response);
                    this.removeFromMDC();
                    return;
                }
                if (this.isInactive((String)user.get())) {
                    ResourceLoginFilter.sendForbidden((HttpServletResponse)response);
                    this.removeFromMDC();
                    return;
                }
                this.setUserSession(request, (String)user.get());
                this.establishUserSession(request, response);
                ResourceLoginFilter.setBearerTokenContext((HttpServletRequest)request);
            }
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
        catch (IllegalArgumentException | AuthenticationException e) {
            LOG.error("doFilter() AuthenticationException", e);
            ResourceLoginFilter.sendError((HttpServletResponse)response);
        }
        finally {
            this.removeFromMDC();
        }
    }

    private static boolean pathRequiresAuthentication(HttpServletRequest request) {
        LOG.debug("pathRequiresAuthentication(...) - Enter");
        String requestedPath = request.getPathInfo();
        boolean pathRequiresAuthentication = !UNAUTHENTICATED_APIS.contains(requestedPath);
        LOG.debug("pathRequiresAuthentication(...) - Exit : pathRequiresAuthentication={}", (Object)pathRequiresAuthentication);
        return pathRequiresAuthentication;
    }

    private boolean isInactive(String principalName) {
        AuthenticationValidationResponse validationResponse = this.getCfAuthenticationService().validatePrincipalName(principalName);
        return validationResponse == AuthenticationValidationResponse.INVALID_PRINCIPAL_CANNOT_LOGIN;
    }

    protected void establishUserSession(HttpServletRequest request, HttpServletResponse response) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession != null) {
            GlobalVariables.setUserSession((UserSession)userSession);
        }
        this.establishSessionCookie(request, response);
        this.establishBackdoorUser(request);
        this.addToMDC(request);
    }

    private Optional<String> getPrincipalNameFromRequest(HttpServletRequest request) {
        Optional<String> user = Optional.empty();
        String authorizationHeader = request.getHeader("Authorization");
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (StringUtils.isNotBlank((CharSequence)authorizationHeader)) {
            user = this.getPrincipalNameFromHeader(authorizationHeader, userSession);
        } else if (this.isUserSessionEstablished(request)) {
            user = Optional.of(userSession.getPrincipalName());
        }
        return user;
    }

    private Optional<String> getPrincipalNameFromHeader(String authorizationHeader, UserSession userSession) {
        if (authorizationHeader == null) {
            return Optional.empty();
        }
        Optional oKey = ResourceLoginFilter.getApiKey((String)authorizationHeader);
        if (oKey.isPresent()) {
            if (this.getCoreApiKeyAuthenticationService().useCore()) {
                return this.getCoreApiKeyAuthenticationService().getPrincipalIdFromApiKey((String)oKey.get(), userSession);
            }
            try {
                JwtData data = this.getJwtService().decodeJwt((String)oKey.get());
                return Optional.of(data.getPrincipalName());
            }
            catch (RuntimeException e) {
                LOG.debug("getPrincipalNameFromHeader() invalid financials token", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private static void sendError(HttpServletResponse response) throws IOException {
        response.setStatus(401);
        response.getWriter().println("[ \"Unauthorized\" ]");
    }

    private static void sendForbidden(HttpServletResponse response) throws IOException {
        response.setStatus(403);
        response.getWriter().println("[ \"Forbidden\" ]");
    }

    protected void setUserSession(HttpServletRequest request, String principalName) {
        UserSession userSession = KRADUtils.getUserSessionFromRequest((HttpServletRequest)request);
        if (userSession == null || userSession.getActualPerson() == null || !StringUtils.equals((CharSequence)userSession.getActualPerson().getPrincipalName(), (CharSequence)principalName)) {
            UserSession newUserSession = new UserSession(principalName);
            request.getSession().setAttribute("userSession", (Object)newUserSession);
        }
    }

    private static Optional<String> getApiKey(String authorizationHeader) {
        if (!authorizationHeader.toLowerCase(Locale.US).startsWith("bearer")) {
            LOG.error("getApiKey() authorization header missing Bearer prefix");
            return Optional.empty();
        }
        String[] split = authorizationHeader.split("\\s+");
        if (split.length != 2) {
            LOG.error("doFilter() authorization header should be two parts");
            return Optional.empty();
        }
        return Optional.of(split[1]);
    }

    protected CoreApiKeyAuthenticationService getCoreApiKeyAuthenticationService() {
        return (CoreApiKeyAuthenticationService)SpringContext.getBean(CoreApiKeyAuthenticationService.class);
    }

    protected JwtService getJwtService() {
        return (JwtService)SpringContext.getBean(JwtService.class);
    }

    private static void setBearerTokenContext(HttpServletRequest request) {
        LOG.debug("setBearerTokenContext(...) - Enter : request={}", (Object)request);
        ResourceLoginFilter.extractBearerToken((HttpServletRequest)request).ifPresent(BearerTokenContext::setBearerToken);
        LOG.debug("setBearerTokenContext(...) - Exit");
    }

    private static Optional<String> extractBearerToken(HttpServletRequest request) {
        String[] tokens;
        LOG.debug("extractBearerToken(...) - Enter : request={}", (Object)request);
        String authorizationHeaderValue = request.getHeader("Authorization");
        LOG.debug("extractBearerToken(...) - authorizationHeaderValue={}", (Object)authorizationHeaderValue);
        if (StringUtils.isNotBlank((CharSequence)authorizationHeaderValue) && (tokens = authorizationHeaderValue.split("\\s+")).length == 2) {
            String bearerToken = tokens[1];
            LOG.debug("extractBearerToken(...) - Exit : bearerToken={}", (Object)bearerToken);
            return Optional.of(bearerToken);
        }
        LOG.debug("extractBearerToken(...) - Exit; empty");
        return Optional.empty();
    }
}

