<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<%@ tag description="render the late adjustment tab" %>

<%@ attribute name="propertyName" required="true"
              description="Name of form property containing the late adjustment fields." %>
<%@ attribute name="attributes" required="true" type="java.util.Map"
              description="The DataDictionary entry containing attributes for fields."%>
<%@ attribute name="defaultOpen" required="true" %>

<c:set var="fullEntryMode" value="${KualiForm.documentActions[KRADConstants.KUALI_ACTION_CAN_EDIT]}"/>

<kul:tab tabTitle="Late Adjustment Certification"
         defaultOpen="${defaultOpen}"
         tabErrorKey="${KFSConstants.LATE_ADJUSTMENT_ERRORS}">
    <div class="tab-container">
        <table class="standard" summary="Late Adjustment Section">
            <tr>
                <th class="right" width="50%">
                    <kul:htmlAttributeLabel attributeEntry="${attributes.expenditureDescription}" noColon="true"/>
                </th>
                <td class="datacell" width="50%">
                    <kul:htmlControlAttribute
                            attributeEntry="${attributes.expenditureDescription}"
                            property="${propertyName}.expenditureDescription"
                            readOnly="${not fullEntryMode}"/>
                </td>
            </tr>
            <tr>
                <th class="right" width="50%">
                    <kul:htmlAttributeLabel attributeEntry="${attributes.expenditureProjectBenefit}" noColon="true"/>
                </th>
                <td class="datacell" width="50%">
                    <kul:htmlControlAttribute
                            attributeEntry="${attributes.expenditureProjectBenefit}"
                            property="${propertyName}.expenditureProjectBenefit"
                            readOnly="${not fullEntryMode}"/>
                </td>
            </tr>
            <tr>
                <th class="right" width="50%">
                    <kul:htmlAttributeLabel attributeEntry="${attributes.lateAdjustmentDescription}" noColon="true"/>
                </th>
                <td class="datacell" width="50%">
                    <kul:htmlControlAttribute
                            attributeEntry="${attributes.lateAdjustmentDescription}"
                            property="${propertyName}.lateAdjustmentDescription"
                            readOnly="${not fullEntryMode}"/>
                </td>
            </tr>
            <tr>
                <th class="right" width="50%">
                    <kul:htmlAttributeLabel attributeEntry="${attributes.lateAdjustmentReason}" noColon="true"/>
                </th>
                <td class="datacell" width="50%">
                    <kul:htmlControlAttribute
                            attributeEntry="${attributes.lateAdjustmentReason}"
                            property="${propertyName}.lateAdjustmentReason"
                            readOnly="${not fullEntryMode}"/>
                </td>
            </tr>
            <c:if test="${not empty attributes.lateAdjustmentActionDescription}">
                <tr>
                    <th class="right" width="50%">
                        <kul:htmlAttributeLabel attributeEntry="${attributes.lateAdjustmentActionDescription}"
                                                noColon="true"/>
                    </th>
                    <td class="datacell" width="50%">
                        <kul:htmlControlAttribute
                                attributeEntry="${attributes.lateAdjustmentActionDescription}"
                                property="${propertyName}.lateAdjustmentActionDescription"
                                readOnly="${not fullEntryMode}"/>
                    </td>
                </tr>
            </c:if>
        </table>
    </div>
</kul:tab>
