<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="docEmailAttributes" value="${DataDictionary.PersonDocumentEmail.attributes}" />

<c:set var="canModify" scope="request" value="${!KualiForm.document.privacy.suppressEmail || KualiForm.canOverrideEntityPrivacyPreferences}" />
<c:set var="maskData" value="${KualiForm.document.privacy.suppressEmail && !KualiForm.canOverrideEntityPrivacyPreferences}" />

<kul:subtab lookedUpCollectionName="email" width="${tableWidth}" subTabTitle="Email Addresses" noShowHideButton="true">      
    <table class="standard side-margins">
        <tr>
            <th>&nbsp;</th> 
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.emailAddress}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.emailTypeCode}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.dflt}" noColon="true" /></div></th>
            <th><div align="left"><kul:htmlAttributeLabel attributeEntry="${docEmailAttributes.active}" noColon="true" /></div></th>
            <c:if test="${not inquiry and canModify}">  
                <kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col"/>
            </c:if>
        </tr>     
        <c:if test="${not inquiry and not readOnlyEntity and canModify}">
            <tr>
                <th class="infoline">Add:</th>
                <td class="infoline">   
                <div align="left">
                  <kul:htmlControlAttribute property="newEmail.emailAddress" attributeEntry="${docEmailAttributes.emailAddress}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td align="left" valign="middle" class="infoline">
                <div align="left">
                    <kul:htmlControlAttribute property="newEmail.emailTypeCode" attributeEntry="${docEmailAttributes.emailTypeCode}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td class="infoline">   
                <div align="left">
                  <kul:htmlControlAttribute property="newEmail.dflt" attributeEntry="${docEmailAttributes.dflt}" readOnly="${readOnlyEntity}" />
                </div>
                </td>
                <td class="infoline">   
                <div align="left">
                  <kul:htmlControlAttribute property="newEmail.active" attributeEntry="${docEmailAttributes.active}" readOnly="${readOnlyEntity}" />
                </div>
                </td>                                
                <td class="infoline">
                    <div align=left>
                        <html:submit property="methodToCall.addEmail.anchor${tabKey}"
                        value="Add" styleClass="btn btn-green"/>
                    </div>
                </td>
            </tr>         
        </c:if>        
        <c:forEach var="email" items="${KualiForm.document.emails}" varStatus="status">
            <c:if test="${!(inquiry and readOnlyEntity and kfunc:isHiddenKimObjectType(email.emailType.code, 'kim.hide.PersonDocumentEmail.type'))}">
              <tr>
                <th class="infoline">
                    <c:out value="${status.index+1}" />
                </th>
                <td>     
                    <div align="left">
                      <kul:htmlControlAttribute property="document.emails[${status.index}].emailAddress" attributeEntry="${docEmailAttributes.emailAddress}" readOnly="${readOnlyEntity or !canModify}" displayMask="${maskData}" displayMaskValue="xxxxx@xxx.xxx" />
                    </div>
                </td>
                <td align="left" valign="middle">
                    <div align="left"> <kul:htmlControlAttribute property="document.emails[${status.index}].emailTypeCode"  attributeEntry="${docEmailAttributes.emailTypeCode}"  readOnlyAlternateDisplay="${fn:escapeXml(email.emailType.name)}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td>
                    <div align="left">
                      <kul:htmlControlAttribute property="document.emails[${status.index}].dflt" attributeEntry="${docEmailAttributes.dflt}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <td>
                    <div align="left">
                      <kul:htmlControlAttribute property="document.emails[${status.index}].active" attributeEntry="${docEmailAttributes.active}" readOnly="${readOnlyEntity or !canModify}" />
                    </div>
                </td>
                <c:if test="${not inquiry and canModify}">                      
                    <td>
                        <div align="left">&nbsp;
                             <c:choose>
                               <c:when test="${email.edit or readOnlyEntity}">
                                   <button class="btn btn-red" disabled>Delete</button>
                               </c:when>
                               <c:otherwise>
                                  <html:submit property='methodToCall.deleteEmail.line${status.index}.anchor${currentTabIndex}'
                                        value="Delete" styleClass='btn btn-red'/>
                               </c:otherwise>
                             </c:choose>  
                        </div>
                    </td>
                </c:if>    
              </tr>
            </c:if>  
        </c:forEach>                    
    </table>
</kul:subtab>
