<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="KualiForm" value="${DocumentOperationForm}" scope="request"/>
<kul:page headerTitle="Document Operation" lookup="false"
    headerMenuBar="" transactionalDocument="false" showDocumentInfo="false"
    htmlFormAction="DocumentOperation" docTitle="Document Operation">

<html-el:html>
<head>
    <script language="JavaScript" src="scripts/en-common.js"></script>
    <script language="JavaScript" src="scripts/kew/documentoperation-common.js"></script>
    <script>
      function clearSearch() {
        window.location.href='DocumentOperation.do?methodToCall=clear';
      }
    </script>
  </head>

  <div class="msg-excol">
    <div class="left-errmsg">
        <kul:errors errorTitle="Errors found in Search Criteria:" />
        <jsp:include page="../WorkflowMessages.jsp" flush="true" />
    </div>
  </div>

  <html-el:form action="/DocumentOperation.do">
    <div id="view_div">
      <kul:tabTop tabTitle="Operate On A Document" defaultOpen="true">
        <div class="tab-container">
        <kul:csrf />
        <table class="standard side-margins" style="margin-top: 25px;">
          <tr>
            <th align="right">
              <div align="right">*Document ID:&nbsp;</div>
            </th>
            <td width="20%">
              <%-- <html-el:text property="routeHeader.documentId" /> --%>
                <html-el:text property="documentId" />
            </td>
            <td align="left">
              <html:submit styleClass="btn btn-primary" property="methodToCall.getDocument" value="Get Document" />
            </td>
          </tr>
        </table>
        </div>
      </kul:tabTop>

          <c:if test="${DocumentOperationForm.routeHeader.documentId != null && DocumentOperationForm.routeHeader.documentId != ''}">
          <jsp:include page="RouteHeader.jsp" flush="true"/>
          <jsp:include page="ActionRequests.jsp" flush="true"/>
          <jsp:include page="ActionsTaken.jsp" flush="true"/>
          <jsp:include page="ActionItems.jsp" flush="true"/>
          <jsp:include page="RouteNodeInstances.jsp" flush="true"/>
          <jsp:include page="BranchStates.jsp" flush="true"/>
          <jsp:include page="AnnotationForAdmin.jsp" flush="true"/>

          <div style="left: 40px;" id="globalbuttons" class="globalbuttons" role="navigation">
              <html:submit styleClass="globalbuttons btn btn-default" property="methodToCall.save" alt="Submit" tabindex="1" value="Submit"/>
              <input tabindex="2" class="btn btn-default" type="button" value="Clear" onclick="clearSearch()"/>
          </div>
          </c:if>
      </div>
    </html-el:form>
  <jsp:include page="../BackdoorMessage.jsp" flush="true"/>
  </html-el:html>
</kul:page>
