/*
 * The Kuali Financial System, a comprehensive financial management system for higher education.
 *
 * Copyright 2005-2022 Kuali, Inc.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

const webpack = require('webpack');
const path = require('path');
const WebpackAssetsManifest = require('webpack-assets-manifest');
const postcssCustomProperties = require('postcss-custom-properties');
const NodePolyfillPlugin = require('node-polyfill-webpack-plugin');

module.exports = {
  target: 'web',
  entry: {
    app: './app/legacy-app.js',
    index: './app/index.js',
    institutionconfig: './app/institution-config/index.js'
  },
  output: {
    path: path.resolve(__dirname, 'build'),
    filename: '[name].bundle.js'
  },
  resolve: {
    symlinks: false,
    alias: {
      lodash: path.resolve(__dirname, 'node_modules/lodash'),
      '~': path.resolve(__dirname, 'app'),
      buffer: require.resolve('buffer/')
    },
    fallback: {
      path: false
    }
  },
  module: {
    rules: [
      {
        test: /node_modules\/vfile\/core\.js/,
        use: [{
          loader: 'imports-loader',
          options: {
            type: 'commonjs',
            imports: ['single process/browser process']
          }
        }]
      },
      {
        test: /\.js$/,
        exclude: [/node_modules/],
        loader: 'babel-loader'
      },
      {
        test: /\.css$/,
        exclude: [/node_modules/],
        use: [
          'style-loader',
          {
            loader: 'css-loader',
            options: {
              modules: true,
              importLoaders: 1
            }
          },
          {
            loader: 'postcss-loader',
            options: {
              postcssOptions: {
                ident: 'postcss',
                plugins: [
                  postcssCustomProperties({
                    preserve: false,
                    importFrom: [
                      './app/variables.css',
                      './node_modules/@kuali/fin-formbot/dist/styles.css'
                    ]
                  })
                ]
              }
            }
          }
        ]
      },
      {
        test: /\.css$/,
        include: [/node_modules/],
        use: ['style-loader', 'css-loader']
      },
      {
        test: /\.(png|jpg|gif|woff|eot|ttf|svg)$/,
        loader: 'url-loader'
      }
    ]
  },
  optimization: {
    splitChunks: {
      cacheGroups: {
        commons: {
          name: 'commons',
          chunks: 'initial'
        }
      }
    }
  },
  plugins: [
    new WebpackAssetsManifest({
      output: 'webpack.manifest.json'
    }),
    new webpack.IgnorePlugin({ resourceRegExp: /^\.\/locale$/, contextRegExp: /moment$/ }),
    new webpack.ProvidePlugin({
      process: 'process/browser.js'
    }),
    new NodePolyfillPlugin()
  ]
};
