<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<style type="text/css">
	table.standard tr td {
		padding: 8px;
	}
	#lookup table.standard th {
		text-align: left;
		padding: 8px;
	}
</style>

<kul:page
	showDocumentInfo="false"
	docTitle="Message Queue Entry"
	headerTitle="Message Entry"
	transactionalDocument="false"
	htmlFormAction="MessageQueue"
>
	<html-el:form action="/MessageQueue.do">
		<kul:csrf />
		<html-el:hidden name="MessageQueueForm" property="methodToCall" />
		<html-el:hidden name="MessageQueueForm" property="showEdit" />
		<html-el:hidden name="MessageQueueForm" property="messageId" />
		<html-el:hidden name="MessageQueueForm" property="messageQueueFromForm.routeQueueId" />
		<html-el:hidden name="MessageQueueForm" property="messageQueueFromForm.versionNumber" />

		<c:set var="showOld" value="false" />
		<c:if test="${not empty MessageQueueForm.messageQueueFromDatabase}">
			<c:set var="showOld" value="true" />
		</c:if>
		<c:set var="inEditMode" value="false" />
		<c:if test="${MessageQueueForm.showEdit == 'yes'}">
			<c:set var="inEditMode" value="true" />
		</c:if>

		<div>
			<jsp:include page="../Messages.jsp" flush="true" />
		</div>
		<div id="view_div" class="main-panel search-results">
			<div id="lookup">
				<table class="standard side-margins" width="70%">
					<tr>
						<td></td>
						<c:if test="${showOld}">
							<th>Existing Message Queue Values</th>
						</c:if>
						<th>New Message Queue Values</th>
					</tr>
					<tr class="odd">
						<td width="10%" align="right">Message Id:</td>
						<c:if test="${showOld}">
							<td><c:out value="${MessageQueueForm.messageQueueFromDatabase.routeQueueId}" /></td>
						</c:if>
						<td><c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />
					</tr>

					<tr class="even">
						<td width="10%" align="right">Queue Date:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.queueDate}" />
							</td>
						</c:if>
						<td>
							<c:out value="${MessageQueueForm.messageQueueFromForm.queueDate}" />
						</td>
					</tr>

					<tr class="odd">
						<td width="10%" align="right">Expiration Date:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.expirationDate}" default="" escapeXml="false"/>
							</td>
						</c:if>
						<td>
							<c:out value="${MessageQueueForm.messageQueueFromDatabase.expirationDate}" default="" escapeXml="false"/>
						</td>
					</tr>

					<tr class="even">
						<td width="10%" align="right">Queue Priority:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.queuePriority}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.queuePriority"/>
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.queuePriority}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="odd">
						<td width="10%" align="right">Queue Status:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.queueStatus}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:select property="messageQueueFromForm.queueStatus">
										<html-el:option value=""></html-el:option>
										<html-el:option value="${KSBConstants.ROUTE_QUEUE_QUEUED}"><c:out value="${KSBConstants.ROUTE_QUEUE_QUEUED_LABEL}" /></html-el:option>
										<html-el:option value="${KSBConstants.ROUTE_QUEUE_ROUTING}"><c:out value="${KSBConstants.ROUTE_QUEUE_ROUTING_LABEL}" /></html-el:option>
										<html-el:option value="${KSBConstants.ROUTE_QUEUE_EXCEPTION}"><c:out value="${KSBConstants.ROUTE_QUEUE_EXCEPTION_LABEL}" /></html-el:option>
									</html-el:select>
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.queueStatus}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="even">
						<td width="10%" align="right">Retry Count:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.retryCount}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.retryCount" size="5" maxlength="2" />
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.retryCount}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="odd">
						<td width="10%" align="right">IP Number:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.ipNumber}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.ipNumber" size="20" maxlength="15"/>
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.ipNumber}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="even">
						<td width="10%" align="right">Service Name:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.serviceName}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.serviceName" size="35" maxlength="50" />
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.serviceName}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="odd">
						<td width="10%" align="right">Method Name:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.methodName}" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.methodName" size="35" maxlength="50" />
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.methodName}" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr class="even">
						<td width="10%" align="right">App Specific Value 1:</td>
						<c:if test="${showOld}">
							<td>
								<c:out value="${MessageQueueForm.messageQueueFromDatabase.value1}" default="" />
							</td>
						</c:if>
						<td>
							<c:choose>
								<c:when test="${inEditMode}">
									<html-el:text property="messageQueueFromForm.value1" size="40" maxlength="15"/>
								</c:when>
								<c:otherwise>
									<c:out value="${MessageQueueForm.messageQueueFromForm.value1}" default="" />
								</c:otherwise>
							</c:choose>
						</td>
					</tr>

					<tr>
						<td colspan="3">
							<c:choose>
								<c:when test="${inEditMode}">

									<a class="btn btn-default" style="margin-bottom: 8px; display: block; width: 220px;" href="javascript: submitQueueId('save', '<c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />')">
										Save Changes
									</a>

									<a class="btn btn-default" style="margin-bottom: 8px; display: block; width: 220px;" href="javascript: submitQueueId('saveAndResubmit', '<c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />')">
										Save Changes and Resubmit
									</a>

									<a class="btn btn-default" style="margin-bottom: 8px; width: 220px;" href="javascript: submitQueueId('saveAndForward', '<c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />')">
										Save and Forward
									</a>

									<c:set var="ipAddresses" value="${MessageQueueForm.ipAddresses}" scope="request" />
									<html-el:select property="ipAddress" style="display: inline-block;">
										<html-el:options collection="ipAddresses" property="value" labelProperty="value"/>
									</html-el:select>

									<a class="btn btn-default" style="margin-bottom: 8px; display: block; width: 220px;" href="javascript: submitQueueId('delete', '<c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />')">
										Delete
									</a>

									<a class="btn btn-default" style="margin-bottom: 8px; display: block; width: 220px;" href="javascript: submitQueueId('reset', '<c:out value="${MessageQueueForm.messageQueueFromForm.routeQueueId}" />')">
										Reset
									</a>
								</c:when>
								<c:otherwise>
									<a href="javascript: setMethod('queueNewMessage');document.forms[0].submit();">Queue new message</a><br>
								</c:otherwise>
							</c:choose>
						</td>
					</tr>
				</table>
			</div>
		</div>

	</html-el:form>
</kul:page>

<script language="JavaScript" src="scripts/messagequeue-common.js"></script>
