<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<c:set var="hasAnyRows" value="${false}" />
<c:if test="${!empty MessageQueueForm.messageQueueRows}">
    <c:if test="${MessageQueueForm.messageQueueRowsSize > 0}">
        <c:set var="hasAnyRows" value="${true}" />
    </c:if>
</c:if>

<kul:page
    showDocumentInfo="false"
    docTitle="Message Queue"
    htmlFormAction="MessageQueue"
    headerTitle="Message Queue"
    transactionalDocument="false"
>
    <div id="view_div" class="main-panel" style="padding-left: 5%;">
        <kul:csrf />
        <html-el:hidden property="methodToCall" />
        <jsp:include page="../Messages.jsp"/>
        <table class="standard side-margins datatable-100">
            <tr>
                <td width="85%">
                    <div id="lookup">
                        <table class="standard side-margins">
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Message ID:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="routeQueueId${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}" size="20"/>
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Service Name:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="serviceName${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}" />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    IP Number:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="ipNumber${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}" size="20" maxlength="15" />
                                    &nbsp;
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Queue Status:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:select property="queueStatus${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}">
                                        <html-el:option value=""></html-el:option>
                                        <html-el:option value="${KSBConstants.ROUTE_QUEUE_QUEUED}"><c:out value="${KSBConstants.ROUTE_QUEUE_QUEUED_LABEL}" /></html-el:option>
                                        <html-el:option value="${KSBConstants.ROUTE_QUEUE_ROUTING}"><c:out value="${KSBConstants.ROUTE_QUEUE_ROUTING_LABEL}" /></html-el:option>
                                        <html-el:option value="${KSBConstants.ROUTE_QUEUE_EXCEPTION}"><c:out value="${KSBConstants.ROUTE_QUEUE_EXCEPTION_LABEL}" /></html-el:option>
                                    </html-el:select>
                                </td>
                            </tr>

                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Create Date From:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="queueDateFrom${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}"
                                                  styleId="queueDateFrom"
                                    />&nbsp;
                                    <img alt="Queue Date From:"
                                         id="queueDateFrom_trigger"
                                         src="${ConfigProperties.externalizable.images.url}cal.png"
                                         style="cursor: pointer;"
                                         title="Date selector"
                                         width="24"
                                    />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Create Date To:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="queueDateTo${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}"
                                                  styleId="queueDateTo"
                                    />&nbsp;
                                    <img alt="Queue Date To:"
                                         id="queueDateTo_trigger"
                                         src="${ConfigProperties.externalizable.images.url}cal.png"
                                         style="cursor: pointer;"
                                         title="Date selector"
                                         width="24"
                                    />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Expiration Date From:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="expirationDateFrom${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}"
                                                  styleId="expirationDateFrom"
                                    />&nbsp;
                                    <img alt="Expiration Date From:"
                                         id="expirationDateFrom_trigger"
                                         src="${ConfigProperties.externalizable.images.url}cal.png"
                                         style="cursor: pointer;"
                                         title="Date selector"
                                         width="24"
                                    />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    Expiration Date To:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="expirationDateTo${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}"
                                                  styleId="expirationDateTo"
                                    />&nbsp;
                                    <img alt="Expiration Date To:"
                                         id="expirationDateTo_trigger"
                                         src="${ConfigProperties.externalizable.images.url}cal.png"
                                         style="cursor: pointer;"
                                         title="Date selector"
                                         width="24"
                                    />
                                </td>
                            </tr>
                            <tr>
                                <td style="padding-right: 5%;" align="right" width="35%" class="thnormal">
                                    App Specific Value 1:
                                </td>
                                <td width="66%" class="datacell">
                                    <html-el:text property="value1${KSBConstants.ROUTE_QUEUE_FILTER_SUFFIX}" size="40"/>
                                </td>
                            </tr>
                        </table>
                    </div>
                </td>
                <td valign="top">
                    <div style="width: 220px; border: 2px solid #F2F2F2; padding: 10px; border-radius: 3px;">
                    <table class="standard side-margins">
                        <tr>
                            <td>
                                Current Node Info
                            </td>
                        </tr>
                        <tr>
                            <td>
                                IP Address: <c:out value="${MessageQueueForm.myIpAddress}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                message.persistence: <c:out value="${MessageQueueForm.messagePersistence}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                message.delivery: <c:out value="${MessageQueueForm.messageDelivery}"/>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                message.off: <c:out value="${MessageQueueForm.messageOff}"/>
                            </td>
                        </tr>
                    </table>
                    </div>
                </td>
            </tr>
        </table>
        <table class="standard side-margins">
            <tr style="border-bottom: 8px solid transparent;">
                <td>
                    <html-el:submit property="filterApplied" value="Filter" styleClass="btn btn-default" />
                </td>
                <td>
                    <a href='MessageQueue.do' title="Clear Filter">
                        <span class="btn btn-default">Clear Filter</span>
                    </a>
                </td>
            </tr>
            <tr>
                <td style="padding-right: 8px;">
                    <input type="button" value="Execute Message Fetcher" class="btn btn-default" onclick="executeMessageFetcher()"/>
                </td>
                <td>
                    <html-el:text property="maxMessageFetcherMessages" size="3"/>
                </td>
            </tr>
        </table>
        <table class="standard side-margins">
            <tr>
                <td height="30">
                    <strong>Documents currently in route queue:</strong>
                    <c:if test="${!hasAnyRows}">
                        None.
                    </c:if>
                    <c:if test="${hasAnyRows}">
                        <c:out value="${MessageQueueForm.messageQueueRowsSize}"/>
                        <c:if test="${MessageQueueForm.messageQueueRowsSize > MessageQueueForm.maxRows}">
                            <c:out value="There were ${MessageQueueForm.maxRows} or more rows, only displaying the first ${MessageQueueForm.maxRows}."/>
                        </c:if>
                    </c:if>
                    <br>
                </td>
            </tr>
        </table>
    </div>
    <c:if test="${hasAnyRows}">
        <div class="main-panel search-results">
            <display:table
                excludedParams="methodToCall reqSearchResultsActualSize searchResultKey searchUsingOnlyPrimaryKeyValues actionUrlsExist"
                pagesize="${MessageQueueForm.pageSize}"
                class="datatable-100"
                name="${MessageQueueForm.messageQueueRows}"
                export="true"
                id="result"
                requestURI="MessageQueue.do?filterApplied=${filterApplied}&queueStatusFilter=${queueStatusFilter}&ipNumberFilter=${ipNumberFilter}&serviceNameFilter=${serviceNameFilter}"
                defaultsort="1"
                defaultorder="descending"
                decorator="org.kuali.kfs.ksb.messaging.web.KSBTableDecorator"
                style="margin: 10px 0;"
            >
                <display:setProperty name="paging.banner.placement" value="both" />
                <display:setProperty name="export.banner" value="" />
                <display:column
                        style="vertical-align:middle; padding: 5px;"
                        class="datacell"
                        sortable="false"
                        title="<div style='vertical-align:top; margin-left: 5px;'>Actions</div>"
                >
                    <a href='MessageQueue.do?methodToCall=view&messageId=<c:out value="${result.routeQueueId}" />'>View</a>
                    <a href='MessageQueue.do?methodToCall=edit&messageId=<c:out value="${result.routeQueueId}" />'>Edit</a>
                    <a href='MessageQueue.do?methodToCall=quickRequeueMessage&messageId=<c:out value="${result.routeQueueId}" />' onClick="return confirm('Are you sure you want to ReQueue this message?\n\nThe QueueDate will be reset to today and the Retry set to zero.');">ReQueue</a>
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Message<br />Queue Id</div>"
                    sortProperty="routeQueueId"
                >
                    <c:out value="${result.routeQueueId}"/>
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Service<br />Name</div>"
                >
                    <c:out value="${result.serviceName}"/>
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='center;vertical-align:top;'>IP Number</div>"
                >
                    <c:out value="${result.ipNumber}"/>&nbsp;
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Queue<br />Status</div>"
                >
                    <c:choose>
                        <c:when test="${result.queueStatus == KSBConstants.ROUTE_QUEUE_QUEUED}">
                            <c:out value="${KSBConstants.ROUTE_QUEUE_QUEUED_LABEL}" />&nbsp;
                        </c:when>
                        <c:when test="${result.queueStatus == KSBConstants.ROUTE_QUEUE_ROUTING}">
                            <c:out value="${KSBConstants.ROUTE_QUEUE_ROUTING_LABEL}" />&nbsp;
                        </c:when>
                        <c:when test="${result.queueStatus == KSBConstants.ROUTE_QUEUE_EXCEPTION}">
                            <c:out value="${KSBConstants.ROUTE_QUEUE_EXCEPTION_LABEL}" />&nbsp;
                        </c:when>
                        <c:otherwise>
                            <c:out value="${result.queueStatus}"/>&nbsp;
                        </c:otherwise>
                    </c:choose>
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Queue<br />Priority</div>"
                >
                    <c:out value="${result.queuePriority}"/>&nbsp;
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Queue<br />Date</div>"
                    sortProperty="queueDate.time"
                >
                    <fmt:formatDate value="${result.queueDate}" pattern="${KFSConstants.DEFAULT_DATE_FORMAT_PATTERN}" />&nbsp;
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Expiration<br />Date</div>"
                    sortProperty="expirationDate.time"
                >
                    <fmt:formatDate value="${result.expirationDate}" pattern="${KFSConstants.DEFAULT_DATE_FORMAT_PATTERN}" />&nbsp;
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>Retry<br />Count</div>"
                >
                    <c:out value="${result.retryCount}"/>&nbsp;
                </display:column>
                <display:column
                    style="vertical-align:middle; padding: 5px;"
                    class="datacell"
                    sortable="true"
                    title="<div style='vertical-align:top;'>App Specific<br />Value 1</div>"
                >
                    <c:out value="${result.value1}"/>&nbsp;
                </display:column>
            </display:table>
        </div>
    </c:if>

    <script type="application/javascript" src="scripts/messagequeue-common.js"></script>

    <script type="text/javascript">
      (function () {
        /* Wires up calendar for all calendars on this page, see button for button it's associated with */
        Calendar.setup({
          inputField     :    "queueDateFrom",     // id of the input field
          ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
          button         :    "queueDateFrom_trigger", // the button or image that triggers this
          showsTime      :    true,            // will display a time selector
          daFormat       :    "%A, %B %d, %Y",// format of the displayed date
          singleClick    :    true,
          timeFormat     :    "12",
          step           :    1
        });

        Calendar.setup({
          inputField     :    "queueDateTo",     // id of the input field
          ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
          button         :    "queueDateTo_trigger", // the button or image that triggers this
          showsTime      :    true,            // will display a time selector
          daFormat       :    "%A, %B %d, %Y",// format of the displayed date
          singleClick    :    true,
          timeFormat     :    "12",
          step           :    1
        });

        Calendar.setup({
          inputField     :    "expirationDateFrom",     // id of the input field
          ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
          button         :    "expirationDateFrom_trigger", // the button or image that triggers this
          showsTime      :    true,            // will display a time selector
          daFormat       :    "%A, %B %d, %Y",// format of the displayed date
          singleClick    :    true,
          timeFormat     :    "12",
          step           :    1
        });

        Calendar.setup({
          inputField     :    "expirationDateTo",     // id of the input field
          ifFormat       :    "%m/%d/%Y",     // format of the input field (even if hidden, this format will be honored)
          button         :    "expirationDateTo_trigger", // the button or image that triggers this
          showsTime      :    true,            // will display a time selector
          daFormat       :    "%A, %B %d, %Y",// format of the displayed date
          singleClick    :    true,
          timeFormat     :    "12",
          step           :    1
        });
      })()
    </script>
</kul:page>
