<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ attribute name="actionRequest"
              description="The action request for which to create an impersonation link"
              required="true"
              type="org.kuali.kfs.kew.actionrequest.ActionRequest"
%>
<%--@elvariable id="KualiForm" type="org.kuali.kfs.kns.web.struts.form.KualiForm"--%>
<c:if test="${actionRequest.approveRequest
              and actionRequest.active
              and KualiForm.impersonationLinkAllowed
              and KualiForm.backdoorEnabled
              and actionRequest.principalId ne sessionScope['userSession'].principalId
              and actionRequest.principalId ne sessionScope['userSession'].loggedInUserPrincipalId
}">
    <a target="_top"
       href="<e:forUri value="${ConfigProperties.application.url}" />/DocHandler.do?command=displayDocSearchView&docId=<e:forUriComponent value="${actionRequest.documentId}" />&backdoorId=<e:forUriComponent value="${actionRequest.person.principalName}" />"
       class="fas fa-backdoor"
       title="Open document acting as <e:forHtmlAttribute value="${actionRequest.person.principalName}" />"
    >Impersonate</a>
</c:if>
