<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="personAttributes" value="${DataDictionary.Person.attributes}" />

<kul:subtab width="${tableWidth}" subTabTitle="Name" noShowHideButton="true">
    <table class="standard side-margins">
        <tr>
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.firstName}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.middleName}" noColon="true" />
            <kim:cell isLabel="true" textAlign="left" attributeEntry="${personAttributes.lastName}" noColon="true" />
        </tr>
        <tr>
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.firstName" attributeEntry="${personAttributes.firstName}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.middleName" attributeEntry="${personAttributes.middleName}" readOnly="${readOnlyEntity}" />
            <kim:cell valign="middle" cellClass="infoline" textAlign="left" property="document.lastName" attributeEntry="${personAttributes.lastName}" readOnly="${readOnlyEntity}" />
        </tr>
    </table>
</kul:subtab>
