<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<%@ taglib uri="/WEB-INF/tlds/institutionConfigWebFunctions.tld" prefix="icwf"%>

<!DOCTYPE html>
<html:html>
    <head>
        <meta http-equiv="content-type" content="text/html; charset=UTF-8" />
        <link rel="shortcut icon" href="${pageContext.request.contextPath}/favicon.ico" type="image/x-icon">
        <title>:: Kuali Financials</title>
        <link rel="stylesheet" href="${pageContext.request.contextPath}/css/bootstrap-replacement.css">
        <link href='https://fonts.googleapis.com/css?family=Roboto:300,400,500,700,900' rel='stylesheet'>
        <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" type="text/css">
        <link href='${pageContext.request.contextPath}/css/newPortal.css?${cachingTimestamp}' rel='stylesheet' type='text/css'>
        <link href='${pageContext.request.contextPath}/css/lookup.css?${cachingTimestamp}' rel='stylesheet' type='text/css'>
        <link rel="stylesheet" href="${pageContext.request.contextPath}/css/remodal.min.css">
        <script src="${pageContext.request.contextPath}/scripts/jquery.min.js"></script>
        <script src="${pageContext.request.contextPath}/scripts/polyfill.min.js"></script>
    </head>
    <body>
        <div id="webapp-root"></div>
        <kul:stayOnPage active="false"/>
        <script src="${kfunc:getManifestResource(pageContext, 'commons.js')}"></script>
        <c:choose>
            <c:when test="${pageContext.request.getPathInfo().contains('/institutionConfig')}">
                <c:choose>
                    <c:when test="${icwf:hasPermission(pageContext.request)}">
                        <script src="${kfunc:getManifestResource(pageContext, 'institutionconfig.js')}"></script>
                    </c:when>
                    <c:otherwise>
                        <c:redirect url="/webapp/unauthorized/Institution%20Configuration"/>
                    </c:otherwise>
                </c:choose>
            </c:when>
            <c:otherwise>
                <script src="${kfunc:getManifestResource(pageContext, 'index.js')}"></script>
            </c:otherwise>
        </c:choose>
        <kul:analytics />
    </body>
</html:html>
