<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="docAffiliationAttributes" value="${DataDictionary.PersonDocumentAffiliation.attributes}"/>

<kul:subtab lookedUpCollectionName="affiliations" width="${tableWidth}" subTabTitle="Affiliations"
            noShowHideButton="true">
    <table class="standard side-margins">
        <tr>
            <th>
                <div align="left">&nbsp;</div>
            </th>
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center"
                      attributeEntry="${docAffiliationAttributes.affiliationTypeCode}" noColon="true"/>
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center"
                      attributeEntry="${docAffiliationAttributes.campusCode}" noColon="true"/>
            <kim:cell inquiry="${inquiry}" isLabel="true" textAlign="center"
                      attributeEntry="${docAffiliationAttributes.dflt}" noColon="true"/>
            <c:if test="${not inquiry}">
                <th>
                    <div align="center">Actions</div>
                </th>
            </c:if>
        </tr>
        <c:if test="${not inquiry and not readOnlyEntity}">
            <tr>
                <th class="infoline">
                    <c:out value="Add:"/>
                </th>

                <td align="left" valign="middle" class="infoline">
                    <div align="center">
                        <kul:htmlControlAttribute property="newAffln.affiliationTypeCode"
                                                  attributeEntry="${docAffiliationAttributes.affiliationTypeCode}"
                                                  disabled="${readOnlyEntity}"/>
                    </div>
                </td>
                <td class="infoline">
                    <div align="center">
                        <kul:htmlControlAttribute property="newAffln.campusCode"
                                                  attributeEntry="${docAffiliationAttributes.campusCode}"
                                                  readOnly="${readOnlyEntity}"/>
                    </div>
                </td>
                <td class="infoline">
                    <div align="center">
                        <kul:htmlControlAttribute property="newAffln.dflt"
                                                  attributeEntry="${docAffiliationAttributes.dflt}"
                                                  readOnly="${readOnlyEntity}"/>
                    </div>
                </td>
                <td class="infoline">
                    <div align=center>
                        <html:submit property="methodToCall.addAffln.anchor${tabKey}" value="Add"
                                     styleClass="btn btn-green"/>
                    </div>
                </td>
            </tr>
        </c:if>
        <c:forEach var="affln" items="${KualiForm.document.affiliations}" varStatus="status">
            <c:set var="rowSpan" value="1"/>
            <c:if test="${affln.employmentAffiliationType or fn:length(affln.empInfos) > 0}">
                <c:set var="rowSpan" value="2"/>
            </c:if>

            <tr>
                <th rowspan="${rowSpan}" class="infoline"/>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center"
                          property="document.affiliations[${status.index}].affiliationTypeCode"
                          attributeEntry="${docAffiliationAttributes.affiliationTypeCode}"
                          readOnlyAlternateDisplay="${fn:escapeXml(affln.affiliationType.name)}" disabled="true"
                          readOnly="false"/>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center"
                          property="document.affiliations[${status.index}].campusCode"
                          attributeEntry="${docAffiliationAttributes.campusCode}" readOnly="${readOnlyEntity}"/>
                <kim:cell inquiry="${inquiry}" valign="middle" cellClass="infoline" textAlign="center"
                          property="document.affiliations[${status.index}].dflt"
                          attributeEntry="${docAffiliationAttributes.dflt}" readOnly="${readOnlyEntity}"/>

                <c:if test="${not inquiry}">
                    <td>
                        <div align=center>&nbsp;
                            <c:choose>
                                <c:when test="${affln.edit  or readOnlyEntity}">
                                    <button class="btn btn-red" disabled>Delete</button>
                                </c:when>
                                <c:otherwise>
                                    <html:submit
                                            property="methodToCall.deleteAffln.line${status.index}.anchor${currentTabIndex}"
                                            value="Delete" styleClass="btn btn-red"/>
                                </c:otherwise>
                            </c:choose></div>
                    </td>
                </c:if>
            </tr>
            <c:if test="${affln.employmentAffiliationType  or fn:length(affln.empInfos) > 0}">
                <tr>
                    <td colspan=5 style="padding:0px;">
                        <kim:personEmpInfo afflnIdx="${status.index}"/>
                    </td>
                </tr>
            </c:if>
        </c:forEach>
    </table>
</kul:subtab>
		
