<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2022 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<script language="JavaScript" src="scripts/kew/documentoperation-common.js"></script>

<kul:tab tabTitle="Route Node Instances" defaultOpen="true">
<div class="tab-container">
  <table class="standard side-margins">
      <c:set var="nodeStateIndex" value="0"/>
      <c:choose>
      <c:when test="${empty DocumentOperationForm.routeNodeInstances}">
      <tr><td class="datacell" colspan="2" align="center" height="15">None</td></tr>
      </c:when>
      <c:otherwise>
      <html-el:hidden property="nodeStatesDelete" value=""/>
        <logic-el:iterate id="routeNodeInstance" name="DocumentOperationForm" property="routeNodeInstances" indexId="ctr">
          <html-el:hidden property="routeNodeInstance[${ctr}].routeNodeInstanceId" />
            <html-el:hidden property="routeNodeInstance[${ctr}].documentId" />
              <html-el:hidden property="routeNodeInstance[${ctr}].versionNumber" />
                <tr>
                  <td width="33%" class="headercell3-b-l" align="right"><b> Route Node Instance ID: </b><c:out value="${routeNodeInstance.routeNodeInstanceId}" /> </td>
                  <td width="66%" class="headercell3-b-l">
                    <html-el:radio property="routeNodeInstanceOp[${ctr}].value" value="update"/>Update &nbsp;&nbsp;
                      <html-el:radio property="routeNodeInstanceOp[${ctr}].value" value="delete"/>Delete&nbsp;&nbsp;
                        <html-el:radio property="routeNodeInstanceOp[${ctr}].value" value="noop"/>No Operation&nbsp;&nbsp;
                          <html-el:hidden property="routeNodeInstanceOp[${ctr}].index" />
                  </td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Instance Name:</td>
                  <td width="66%" class="datacell"><c:out value="${routeNodeInstance.routeNode.routeNodeName}" /></td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Active Indicator:</td>
                  <td width="66%" class="datacell"><html-el:text name="DocumentOperationForm" property="routeNodeInstance[${ctr}].active" /></td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Complete Indicator:</td>
                  <td width="66%" class="datacell"><html-el:text name="DocumentOperationForm" property="routeNodeInstance[${ctr}].complete" /></td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Initial Indicator:</td>
                  <td width="66%" class="datacell"><html-el:text name="DocumentOperationForm" property="routeNodeInstance[${ctr}].initial"/></td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Previous Route Node Instances:</td>
                  <td width="66%" class="datacell">
                    <c:choose>
                    <c:when test="${empty routeNodeInstance.previousNodeInstances}">
                    None
                    </c:when>
                    <c:otherwise>
                    <c:forEach var="preInstance" items="${routeNodeInstance.previousNodeInstances}" varStatus="loopStatus">
                    <c:out value="${preInstance.routeNodeInstanceId}"/><c:if test="${!loopStatus.last}">,&nbsp;</c:if>
                    </c:forEach>
                    </c:otherwise>
                    </c:choose>
                  </td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Next Route Node Instances:</td>
                  <td width="66%" class="datacell">
                    <c:choose>
                    <c:when test="${empty routeNodeInstance.nextNodeInstances}">
                    None
                    </c:when>
                    <c:otherwise>
                    <c:forEach var="nextInstance" items="${routeNodeInstance.nextNodeInstances}" varStatus="loopStatus">
                    <c:out value="${nextInstance.routeNodeInstanceId}"/><c:if test="${!loopStatus.last}">,&nbsp;</c:if>
                    </c:forEach>
                    </c:otherwise>
                    </c:choose>
                  </td>
                </tr>
                <tr>
                  <td width="33%" align="right" class="thnormal">Route Node States:</td>
                  <td width="66%" class="datacell">
                    <c:choose>
                    <c:when test="${empty routeNodeInstance.state}">
                    None
                    </c:when>
                    <c:otherwise>
                    <logic-el:iterate id="routeNodeState" name="DocumentOperationForm" property="routeNodeInstance[${ctr}].state" indexId="ctr1">
                      <html-el:hidden property="routeNodeInstance[${ctr}].nodeStateByIndex[${ctr1}].nodeStateId"/>
                        <html-el:hidden property="routeNodeInstance[${ctr}].nodeStateByIndex[${ctr1}].versionNumber"/>
                          Route Node State: <c:out value="${routeNodeState.nodeStateId}"/>&nbsp;&nbsp;&nbsp;&nbsp; <html-el:button property="nodeStateDeleteOp[${nodeStateIndex}].value" value="delete ${routeNodeState.nodeStateId}" onclick="changeValue(this,${ctr},${ctr1})"/><br>
                          Key: &nbsp;&nbsp;&nbsp;&nbsp;<html-el:text property="routeNodeInstance[${ctr}].nodeStateByIndex[${ctr1}].key"/><br>
                          Value: &nbsp;&nbsp;<html-el:text property="routeNodeInstance[${ctr}].nodeStateByIndex[${ctr1}].value"/><br>
                          <c:set var="nodeStateIndex" value="${nodeStateIndex + 1}"/>
                    </logic-el:iterate>
                    </c:otherwise>
                    </c:choose>
                  </td>
                </tr>
        </logic-el:iterate>
        </c:otherwise>
        </c:choose>
    </table>
  </div>
</kul:tab>
