<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<kul:tab tabTitle="Tax Information" defaultOpen="false" tabErrorKey="${KFSConstants.DV_NONRESIDENTTAX_TAB_ERRORS}">
    <c:set var="nonresidentTaxAttributes" value="${DataDictionary.DisbursementVoucherNonresidentTax.attributes}"/>

    <div class="tab-container">
        <table cellpadding=0 class="datatable standard" summary="Nonresident Tax Section">
            <tr>
                <th width="25%">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.incomeClassCode}"/></div>
                </th>
                <td width="25%">
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.incomeClassCode}"
                                              property="document.dvNonresidentTax.incomeClassCode"
                                              extraReadOnlyProperty="document.dvNonresidentTax.incomeClassName"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
                <th width="25%" scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.foreignSourceIncomeCode}"/></div>
                </th>
                <td width="25%">
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.foreignSourceIncomeCode}"
                                              property="document.dvNonresidentTax.foreignSourceIncomeCode"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.federalIncomeTaxPercent}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.federalIncomeTaxPercent}"
                                              property="document.dvNonresidentTax.federalIncomeTaxPercent"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                    <c:if test="${taxEntryMode and empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}">
                        <!-- These hidden tags contain static values that can be picked up by new lookups to pre-populate fields -->
                        <input type="hidden" name="static.federalTaxPercentIncomeTaxTypeCode" value="F" />
                        <input type="hidden" name="static.federalTaxPercentActive" value="Y" />
                        <kul:lookup boClassName="org.kuali.kfs.fp.businessobject.NonresidentTaxPercent"
                                    fieldConversions="incomeTaxTypeCode:static.federalTaxPercentIncomeTaxTypeCode,active:federalTaxPercentActive,incomeTaxPercent:document.dvNonresidentTax.federalIncomeTaxPercent,incomeClassCode:document.dvNonresidentTax.incomeClassCode"
                                    lookupParameters="document.dvNonresidentTax.incomeClassCode:incomeClassCode,static.federalTaxPercentIncomeTaxTypeCode:incomeTaxTypeCode,document.dvNonresidentTax.federalIncomeTaxPercent:incomeTaxPercent"
                                    splitParameters="document.dvNonresidentTax.incomeClassCode:0"
                                    fieldPropertyName="document.dvNonresidentTax.federalIncomeTaxPercent"
                                    readOnlyFields="active,incomeTaxTypeCode"
                                    newLookup="true"/>
                    </c:if>
                </td>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.incomeTaxTreatyExemptCode}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.incomeTaxTreatyExemptCode}"
                                              property="document.dvNonresidentTax.incomeTaxTreatyExemptCode"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.stateIncomeTaxPercent}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.stateIncomeTaxPercent}"
                                              property="document.dvNonresidentTax.stateIncomeTaxPercent"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                    <c:if test="${taxEntryMode and empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}">
                        <!-- These hidden tags contain static values that can be picked up by new lookups to pre-populate fields -->
                        <input type="hidden" name="static.stateTaxPercentIncomeTaxTypeCode" value="S" />
                        <input type="hidden" name="static.stateTaxPercentActive" value="Y" />
                        <kul:lookup boClassName="org.kuali.kfs.fp.businessobject.NonresidentTaxPercent"
                                    fieldConversions="incomeTaxTypeCode:static.stateTaxPercentIncomeTaxTypeCode,active:stateTaxPercentActive.active,incomeTaxPercent:document.dvNonresidentTax.stateIncomeTaxPercent,incomeClassCode:document.dvNonresidentTax.incomeClassCode"
                                    lookupParameters="document.dvNonresidentTax.incomeClassCode:incomeClassCode,staticIncomeTaxTypeCode:incomeTaxTypeCode,document.dvNonresidentTax.stateIncomeTaxPercent:incomeTaxPercent:document.dvNonresidentTax.stateIncomeTaxPercent"
                                    splitParameters="document.dvNonresidentTax.incomeClassCode:0"
                                    fieldPropertyName="document.dvNonresidentTax.stateIncomeTaxPercent"
                                    readOnlyFields="active,incomeTaxTypeCode"
                                    newLookup="true"/>
                    </c:if>
                </td>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.taxOtherExemptIndicator}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.taxOtherExemptIndicator}"
                                              property="document.dvNonresidentTax.taxOtherExemptIndicator"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel attributeEntry="${nonresidentTaxAttributes.postalCountryCode}"/>
                        <c:if test="${taxEntryMode}"><br> *required unless Income Class Code is Non Reportable</c:if>
                    </div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.postalCountryCode}"
                                              property="document.dvNonresidentTax.postalCountryCode"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.incomeTaxGrossUpCode}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.incomeTaxGrossUpCode}"
                                              property="document.dvNonresidentTax.incomeTaxGrossUpCode"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <div align="right">
                        <kul:htmlAttributeLabel attributeEntry="${nonresidentTaxAttributes.taxNQIId}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute
                            attributeEntry="${nonresidentTaxAttributes.taxNQIId}"
                            property="document.dvNonresidentTax.taxNQIId"
                            readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.taxUSAIDPerDiemIndicator}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.taxUSAIDPerDiemIndicator}"
                                              property="document.dvNonresidentTax.taxUSAIDPerDiemIndicator"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <tr>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.referenceFinancialDocumentNumber}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.referenceFinancialDocumentNumber}"
                                              property="document.dvNonresidentTax.referenceFinancialDocumentNumber"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
                <th scope="row">
                    <div align="right"><kul:htmlAttributeLabel
                            attributeEntry="${nonresidentTaxAttributes.taxSpecialW4Amount}"/></div>
                </th>
                <td>
                    <kul:htmlControlAttribute attributeEntry="${nonresidentTaxAttributes.taxSpecialW4Amount}"
                                              property="document.dvNonresidentTax.taxSpecialW4Amount"
                                              readOnly="${!taxEntryMode or not empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}"/>
                </td>
            </tr>

            <c:if test="${taxEntryMode}">
                <tr>
                    <td class="infoline center" colspan="4">
                        <c:if test="${empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}">
                            <html:submit
                                    styleClass="btn btn-default"
                                    property="methodToCall.generateNonresidentTaxLines"
                                    title="Generate Nonresident Tax Lines"
                                    alt="Generate Nonresident Tax Lines"
                                    value="Generate Lines"/>
                            <html:submit
                                    styleClass="btn btn-default"
                                    property="methodToCall.clearNonresidentTaxInfo"
                                    title="Clear All Info From Nonresident Tax Entries"
                                    alt="Clear All Info From Nonresident Tax Entries"
                                    value="Clear All"/>
                        </c:if>
                        <c:if test="${!empty KualiForm.document.dvNonresidentTax.financialDocumentAccountingLineText}">
                            <html:submit
                                    styleClass="btn btn-default"
                                    property="methodToCall.clearNonresidentTaxLines"
                                    title="Clear Nonresident Tax Lines"
                                    alt="Clear Nonresident Tax Lines"
                                    value="Clear Lines"/>
                            <html:submit
                                    styleClass="btn btn-default"
                                    property="methodToCall.clearNonresidentTaxInfo"
                                    title="Clear All Info From Nonresident Tax Entries"
                                    alt="Clear All Info From Nonresident Tax Entries"
                                    value="Clear All"/>
                        </c:if>
                    </td>
                </tr>
            </c:if>
        </table>

    </div>
</kul:tab>
