<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2025 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="groupMemberAttributes" value="${DataDictionary.GroupDocumentMember.attributes}" />
<c:set var="groupQualifierAttributes" value="${DataDictionary.GroupDocumentQualifier.attributes}" />

<kul:tab tabTitle="Assignees" defaultOpen="true" tabErrorKey="document.member*">
    <c:if test="${empty KualiForm.document.groupNamespace}">
    <div class="tab-container" style="margin: 20px">Select a Group Namespace to determine if you have the appropriate permission to add members to this group</div>
    </c:if>
	<div class="tab-container" align="center">
	    <kul:tableRenderPagingBanner pageNumber="${KualiForm.memberTableMetadata.viewedPageNumber}"
	                                totalPages="${KualiForm.memberTableMetadata.totalNumberOfPages}"
	                                firstDisplayedRow="${KualiForm.memberTableMetadata.firstRowIndex}"
	                                lastDisplayedRow="${KualiForm.memberTableMetadata.lastRowIndex}"
	                                resultsActualSize="${KualiForm.memberTableMetadata.resultsActualSize}"
	                                resultsLimitedSize="${KualiForm.memberTableMetadata.resultsLimitedSize}"
	                                buttonExtraParams=".anchor${currentTabIndex}"/>
	    <input type="hidden" name="memberTableMetadata.${KRADConstants.TableRenderConstants.PREVIOUSLY_SORTED_COLUMN_INDEX_PARAM}" value="${KualiForm.memberTableMetadata.columnToSortIndex}"/>
	    <input type="hidden" name="memberTableMetadata.sortDescending" value="${KualiForm.memberTableMetadata.sortDescending}"/>
	    <input type="hidden" name="memberTableMetadata.viewedPageNumber" value="${KualiForm.memberTableMetadata.viewedPageNumber}"/>
	    <c:if test="${canAssignGroup}">
	      <table cellpadding="0" cellspacing="0" summary="" class="datatable standard acct-lines">
	    	  <tr class="title">
                <td colspan=8 class="tab-subhead">
                    Add Member:
                </td>
          </tr>
	          <tr class="header first">
                  <th class="infoline"></th>
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberTypeCode}" horizontal="false" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberId}" horizontal="false" />
	        		<c:if test='${KualiForm.member.memberTypeCode == "G"}'>
	        		  <kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberNamespaceCode}" horizontal="false" />
	        		</c:if>
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberName}" horizontal="false" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.activeFromDate}" horizontal="false" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.activeToDate}" horizontal="false" />
					<c:if test="${canAssignGroup}">
	            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col" horizontal="false" />
					</c:if>
	          </tr>
	          <tr class="new last">
				  <th class="infoline"></th>
				  <td valign="top" class="infoline">
		                <div>
		                	<kul:htmlControlAttribute property="member.memberTypeCode"
		                	attributeEntry="${groupMemberAttributes.memberTypeCode}"
		                	onchange="changeMemberTypeCode( this.form );" disabled="${readOnly}" />
			            </div>
		            	<c:set var="bo" value="${KualiForm.memberBusinessObjectName}"/>
		            	<c:set var="fc" value="${KualiForm.memberFieldConversions}"/>
					</td>
	                <td align="left" class="infoline">
						<div>
							<kul:htmlControlAttribute property="member.memberId" attributeEntry="${groupMemberAttributes.memberId}" readOnly="${readOnly}"/>
							<c:if test="${!readOnly}">
								<kul:lookup boClassName="${bo}" fieldConversions="${fc}" anchor="${tabKey}" />
							</c:if>
						</div>
					</td>
					<c:if test='${KualiForm.member.memberTypeCode == "G"}'>
					  <td align="left" class="infoline">
						  <div>
							  <kul:htmlControlAttribute property="member.memberNamespaceCode" attributeEntry="${groupMemberAttributes.memberNamespaceCode}" readOnly="${readOnly}" />
						  </div>
					  </td>
					</c:if>
				    <td align="left" class="infoline">
					    <div>
						    <kul:htmlControlAttribute property="member.memberName" attributeEntry="${groupMemberAttributes.memberName}" readOnly="${readOnly}" />
						    <c:if test="${!readOnly}">
							    <kul:lookup boClassName="${bo}" fieldConversions="${fc}" anchor="${tabKey}" />
						    </c:if>
					    </div>
				    </td>
	                <td align="left" class="infoline">
						<kul:htmlControlAttribute property="member.activeFromDate" attributeEntry="${groupMemberAttributes.activeFromDate}" datePicker="true" readOnly="${readOnly}" />
	                </td>
	                <td align="left" class="infoline">
	                	<kul:htmlControlAttribute property="member.activeToDate" attributeEntry="${groupMemberAttributes.activeToDate}" datePicker="true" readOnly="${readOnly}" />
	                </td>
	                <td align="left" class="infoline">
                        <html:html-button property="methodToCall.addMember.anchor${tabKey}" styleClass="btn btn-green skinny" innerHTML="<span class=\"fa fa-plus\"></span>" />
                    </td>
	    	 </tr>
		  </table>
		</c:if>
	    <br /><br />
	    <table cellpadding="0" cellspacing="0" summary="" class="datatable standard old-new">
	    	  <tr>
                <td colspan=9 class="tab-subhead">Members:</td>
              </tr>
	        	<tr>
	        		<th>
						<input type="hidden" id="sortMethodToCallPlaceholder" name="sortMethodToCallPlaceholder" value="placeholder"/>
					</th>
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberTypeCode}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.memberTypeCode';submitForm();" />
                    <kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberId}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.memberId';submitForm();" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberNamespaceCode}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.memberNamespaceCode';submitForm();" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberName}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.memberName';submitForm();" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.memberFullName}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.memberFullName';submitForm();" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.activeFromDate}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.activeFromDate';submitForm();" />
	        		<kul:htmlAttributeHeaderCell attributeEntry="${groupMemberAttributes.activeToDate}" horizontal="false" headerLink="javascript:document.forms[0].sortMethodToCallPlaceholder.name='methodToCall.sort.activeToDate';submitForm();" />
					<c:if test="${canAssignGroup}">
	            		<kul:htmlAttributeHeaderCell literalLabel="Actions" scope="col" horizontal="false" />
					</c:if>
	        	</tr>
			<c:if test="${KualiForm.memberTableMetadata.firstRowIndex >= 0}">
	      	<c:forEach var="member" items="${KualiForm.document.members}" varStatus="statusMember"
                 begin="${KualiForm.memberTableMetadata.firstRowIndex}"
                 end="${KualiForm.memberTableMetadata.lastRowIndex}">
                 <c:set var="inquiryClass" value="org.kuali.kfs.kim.impl.identity.Person" />
                 <c:set var="keyValue" value="principalId" />
                 <c:if test='${member.memberTypeCode == "G"}'>
                   <c:set var="inquiryClass" value="org.kuali.kfs.kim.impl.group.Group" />
                   <c:set var="keyValue" value="id" />
                 </c:if>
	             <tr>
					<th class="infoline" valign="top">
						<c:out value="${statusMember.index+1}" />
					</th>
		            <td>
		               	<div>
							<kul:htmlControlAttribute property="document.members[${statusMember.index}].memberTypeCode"  attributeEntry="${groupMemberAttributes.memberTypeCode}" disabled="true" readOnly="false" />
						</div>
					</td>
		            <td>
		               	<div>
							<kul:htmlControlAttribute property="document.members[${statusMember.index}].memberId"  attributeEntry="${groupMemberAttributes.memberId}" readOnly="true" />
						</div>
					</td>
					<td>
                     	<div>
							<kul:htmlControlAttribute property="document.members[${statusMember.index}].memberNamespaceCode"  attributeEntry="${groupMemberAttributes.memberNamespaceCode}" readOnly="true"  />
						</div>
                    </td>
					<td>
						<div>
                    		<kul:inquiry boClassName="${inquiryClass}" keyValues="${keyValue}=${member.memberId}" render="true">
								<kul:htmlControlAttribute property="document.members[${statusMember.index}].memberName"  attributeEntry="${groupMemberAttributes.memberName}" readOnly="true"  />
							</kul:inquiry>
						</div>
					</td>
		            <td>
		            	<div>
	                    	<kul:inquiry boClassName="${inquiryClass}" keyValues="${keyValue}=${member.memberId}" render="true">
    	                    	<kul:htmlControlAttribute property="document.members[${statusMember.index}].memberFullName"  attributeEntry="${groupMemberAttributes.memberFullName}" readOnly="true"  />
                    		</kul:inquiry>
                    	</div>
                    </td>
					</td>
		            <td>
		               	<div>
							<kul:htmlControlAttribute property="document.members[${statusMember.index}].activeFromDate"  attributeEntry="${groupMemberAttributes.activeFromDate}" readOnly="${!canAssignGroup}" datePicker="true" />
						</div>
					</td>
		            <td>
		               	<div>
							<kul:htmlControlAttribute property="document.members[${statusMember.index}].activeToDate"  attributeEntry="${groupMemberAttributes.activeToDate}" readOnly="${!canAssignGroup}" datePicker="true" />
						</div>
					</td>
          <c:if test="${canAssignGroup}">
              <td>
                  <div>
                      <html:submit property='methodToCall.deleteMember.line${statusMember.index}.anchor${currentTabIndex}'
                      styleClass="btn btn-red skinny" value="Inactivate" />
                  </div>
              </td>
          </c:if>
				</tr>
			</c:forEach>
			</c:if>
		</table>
		<br />
	</div>
</kul:tab>
