<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<table class="datatable-100" style="width: 95%; margin: 0 auto;" id="row">
	<tbody>
	<tr>
		<kul:htmlAttributeHeaderCell
			scope="col"
			align="left"
			attributeEntry="${permissionAttributes['template.name']}"
		/>
		<kul:htmlAttributeHeaderCell
			scope="col"
			align="left"
			attributeEntry="${permissionAttributes.name}"
		/>
		<kul:htmlAttributeHeaderCell
			scope="col"
			align="left"
			attributeEntry="${permissionAttributes.detailObjectsValues}"
		/>
		<kul:htmlAttributeHeaderCell
			scope="col"
			align="left"
			attributeEntry="${permissionAttributes.assignedToRolesToDisplay}"
		/>
		<c:if test="${KualiForm.canInitiatePermissionDocument}">
			<th>
				<a href="<c:url value="${ConfigProperties.application.url}/${KRADConstants.MAINTENANCE_ACTION}">
						<c:param name="methodToCall" value="newWithExisting" />
						<%-- TODO: replace this class name with the interface or maintenance class and let module service handle --%>
						<c:param name="businessObjectClassName" value="org.kuali.kfs.kim.impl.permission.Permission"/>
						<c:param name="attributeDetails.kimAttribute.attributeName" value="documentTypeName"/>
						<c:param name="attributeDetails.attributeValue" value="${docTypeNameVar}"/>
					</c:url>" target="_blank">
					Add Permission
				</a>
			</th>
		</c:if>
	</tr>

	<c:forEach var="perm" items="${permissions}">
		<tr <c:if test="${perm.overridden}">class="overridden"</c:if>>
			<td>
					<%-- TODO: update this to use the proper url for an inquiry and not use the impl class --%>
				<kul:inquiry
					boClassName="org.kuali.kfs.kim.impl.permission.PermissionTemplate"
					keyValues="id=${perm.template.id}"
					render="true"
					noExternalWindow="true"
				>
					<c:out value="${perm.template.name}" />
					(<c:out value="${perm.template.namespaceCode}" />)
				</kul:inquiry>
			</td>
			<td>
					<%-- TODO: update this to use the proper url for a detailed inquiry and not use the impl class --%>
				<kul:inquiry
					boClassName="org.kuali.kfs.kim.impl.permission.Permission"
					keyValues="id=${perm.id}"
					render="true"
					noExternalWindow="true"
				>
					<c:if test="${empty perm.name}">
						<c:out value="${perm.template.name}" />
					</c:if>
					<c:out value="${perm.name}" />
					(<c:out value="${perm.namespaceCode}" />)
				</kul:inquiry>
			</td>
			<td>
					<%-- skip output of the documentTypeName since in subhead --%>
				<c:set var="permDisplayed" value="false" />
				<c:forEach var="dtl" items="${perm.details}" varStatus="status">
					<c:if test="${dtl.key != 'documentTypeName'}">
						<c:if test="${permDisplayed}"><br /></c:if>
						<c:if test="${!permDisplayed}"><c:set var="permDisplayed" value="true" /></c:if>
						<c:out value="${attributeLabels[dtl.key]} = ${dtl.value}" />
					</c:if>
				</c:forEach>
				<c:if test="${!permDisplayed}">
					&nbsp;
				</c:if>
			</td>
			<td>
				<c:forEach var="role" items="${KualiForm.permissionRoles[perm.id]}">
					<kul:inquiry
						boClassName="org.kuali.kfs.kim.impl.role.Role"
						keyValues="id=${role.id}"
						render="true"
						noExternalWindow="true"
					>
						<c:out value="${role.namespaceCode} ${role.name}" />
					</kul:inquiry>
					<br />
				</c:forEach>
				<c:if test="${empty KualiForm.permissionRoles[perm.id]}">
					&nbsp;
				</c:if>
			</td>
			<c:if test="${KualiForm.canInitiatePermissionDocument}">
				<td>
					<a href="<c:url value="${ConfigProperties.application.url}/${KRADConstants.MAINTENANCE_ACTION}">
		                                <c:param name="methodToCall" value="edit" />
		                                <c:param name="businessObjectClassName" value="org.kuali.kfs.kim.impl.permission.Permission"/>
		                                <c:param name="id" value="${perm.id}"/>
	                                </c:url>" target="_blank">Edit Permission</a>
				</td>
			</c:if>
		</tr>
	</c:forEach>
	</tbody>
</table>
