<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2024 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp" %>

<%--Leaving this here, as it may be needed for the non-AR work.--%>
<%--<c:set var="accountsCanCrossCharts"--%>
<%--       value="<%=SpringContext.getBean(AccountService.class).accountsCanCrossCharts()%>"/>--%>

<kul:documentPage showDocumentInfo="false"
                  disableLegacyStyles="true"
                  headerTitle="Payment Application Adjustment"
                  docTitle=""
                  documentTypeName="PaymentApplicationAdjustmentDocument"
                  htmlFormAction="arPaymentApplicationAdjustment" renderMultipart="true"
                  showTabButtons="false"
                  disableLegacyCalendar="true">
    <script type="text/javascript">
        var documentData = {
            requestOptions: {
                root: "arPaymentApplicationAdjustment",
                token: "${sessionScope.csrfSessionToken}"
            },
            id: <c:out value="${KualiForm.docId}"/>,
            title: "<c:out value="${DataDictionary['PaymentApplicationAdjustmentDocument'].label}"/>",
            documentActions: <c:out value="${KualiForm.documentActionsJson}" escapeXml="false" />,
            controlTotal: <c:out value="${KualiForm.document.totalDollarAmount}" />,
            description: "<c:out value="${KualiForm.documentDescription}"/>",
            explanation: "<c:out value="${KualiForm.documentExplanationEscaped}"/>",
            orgDocNumber: "<c:out value="${KualiForm.organizationDocumentNumber}"/>",
            headerFields: <c:out value="${KualiForm.headerFieldsJson}" escapeXml="false" />,
            invoiceApplications: <c:out value="${KualiForm.invoiceResponsesJson}" escapeXml="false" />,
            nonAppliedHoldings: <c:out value="${KualiForm.nonAppliedHoldingsJson}" escapeXml="false" />,
            accountingLines: <c:out value="${KualiForm.accountingLinesJson}" escapeXml="false" />,
            notesAndAttachments: <c:out value="${KualiForm.notesAndAttachmentsJson}" escapeXml="false" />,
            attachmentMaxFileSize: <c:out value="${KualiForm.attachmentMaxFileSize}"/>,
            generalLedgerPendingEntries: <c:out value="${KualiForm.generalLedgerPendingEntriesJson}" escapeXml="false" />,
            buttonGroup: <c:out value="${KualiForm.buttonGroupJson}" escapeXml="false" />,
            routeLog: <c:out value="${KualiForm.routeLogResponseJson}" escapeXml="false" />,
            superUser: {
                isSuperUser: <c:out value="${KualiForm.superUserAuthorized}" escapeXml="false" />,
                canApproveDocument: <c:out value="${KualiForm.stateAllowsApproveOrDisapprove and KualiForm.superUserApproveDocumentAuthorized}" escapeXml="false" />,
                canDisapproveDocument: <c:out value="${KualiForm.stateAllowsApproveOrDisapprove and KualiForm.superUserDisapproveDocumentAuthorized}" escapeXml="false" />,
                canApproveSingleActionRequest: <c:out value="${KualiForm.superUserApproveSingleActionRequestAuthorized}" escapeXml="false" />,
                actionsAvailable: <c:out value="${KualiForm.superUserActionAvaliable}" escapeXml="false" />
            },
            adHocRouting: {
                groups: <c:out value="${KualiForm.adHocRouteWorkgroupJson}" escapeXml="false" />,
                persons: <c:out value="${KualiForm.adHocRoutePersonJson}" escapeXml="false" />,
                actionRequestCodes: <c:out value="${KualiForm.adHocActionRequestCodesJson}" escapeXml="false" />
            }
        }
    </script>
    <div id="documentRoot" data-document-type="APPA"></div>
</kul:documentPage>
