/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.kfs.web;

import com.fasterxml.jackson.databind.json.JsonMapper;
import javax.servlet.ServletContext;
import javax.servlet.jsp.PageContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kuali.kfs.core.JacksonTestUtils;
import org.kuali.kfs.sys.context.SpringContext;
import org.kuali.kfs.web.JavascriptUtils;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class JavascriptUtilsTest {
    @Mock
    private PageContext pageContextMock;
    @Mock
    private ServletContext servletContextMock;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.pageContextMock.getServletContext()).thenReturn((Object)this.servletContextMock);
        String testManifestPath = this.getClass().getClassLoader().getResource("org.kuali.kfs.web/").getPath();
        Mockito.when((Object)this.servletContextMock.getRealPath(Mockito.anyString())).thenReturn((Object)testManifestPath);
        Mockito.when((Object)this.servletContextMock.getContextPath()).thenReturn((Object)"");
    }

    @Test
    public void validBundle() throws Exception {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(JsonMapper.class, (String)"jsonMapperWithJavaTime")).thenReturn((Object)JacksonTestUtils.getJsonMapperWithJavaTime());
            String actual = JavascriptUtils.getManifestResource((PageContext)this.pageContextMock, (String)"test.js");
            Assertions.assertEquals((Object)"/build/test.12345.bundle.js", (Object)actual);
        }
    }

    @Test
    public void invalidBundle() throws Exception {
        try (MockedStatic springContextStaticMock = Mockito.mockStatic(SpringContext.class);){
            springContextStaticMock.when(() -> SpringContext.getBean(JsonMapper.class, (String)"jsonMapperWithJavaTime")).thenReturn((Object)JacksonTestUtils.getJsonMapperWithJavaTime());
            String actual = JavascriptUtils.getManifestResource((PageContext)this.pageContextMock, (String)"invalid.js");
            Assertions.assertEquals((Object)"/build/null", (Object)actual);
        }
    }
}

