<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>
<style>
    .compact {
        border: 5px solid rgba(200, 200, 200, 0.3);
    }

    .compact thead tr th.collapsed-header {
        font-weight: bold;
        font-weight: 700;
        border: 1px solid #E1E1E1;
        background-color: #F7F7F7;
        padding: 8px 0 8px 8px;
    }

    .compact thead tr th.collapsed-header:last-child {
        border-right: none;
    }

    .compact tr.tab-subhead {
        width: 100%;
    }

    .compact tr.tab-subhead td.grid {
        height: 2.8rem;
        border: 1px solid #E1E1E1;
        padding: 8px 0 8px 8px;
    }

    .compact tr.tab-subhead td.grid:last-child {
        border-right: none;
    }

    .sub-section td {
        padding: 5px 0 5px 8px;
    }

    .sub-section td.spacer {
        background-color: rgba(200, 200, 200, 0.3);
        width: 56px;
    }

    .sub-section td:nth-child(2) {
        font-weight: 500;
        width: 175px;
        padding-left: 8px;
    }

    .hidden-row {
        display: none;
    }
</style>

<%-- settting FieldSections to KualiForm.sections --%>
<c:set var="FieldSections" value="${KualiForm.sections}" />
<c:if test="${param.mode eq 'standalone' and !empty kualiInquirable.title}">
    <div>
        <div class="headerarea-small" id="headerarea-small">
            <h1>${kualiInquirable.title}</h1>
        </div>
    </div>
</c:if>

<html:hidden property="businessObjectClassName"/>

<c:forEach items="${KualiForm.inquiryPrimaryKeys}" var="primaryKey">
    <input type="hidden" name="previousPkValue_${primaryKey.key}" value="<c:out value="${primaryKey.value}"/>"/>
</c:forEach>

<c:forEach items="${KualiForm.inactiveRecordDisplay}" var="entry">
    <input type="hidden" name="${KRADConstants.INACTIVE_RECORD_DISPLAY_PARAM_PREFIX}${entry.key}" value="${entry.value}"/>
</c:forEach>

<%-- Show the information about the business object. --%>
<c:forEach items="${FieldSections}" var="section">
    <%-- call helper tag to look ahead through fields for old to new changes, and highlight tab if so --%>
    <kul:checkTabHighlight rows="${section.rows}" addHighlighting="false" />

    <kul:tab tabTitle="${section.sectionTitle}" defaultOpen="${section.defaultOpen}" tabErrorKey="${section.errorKey}" highlightTab="${tabHighlight}" transparentBackground="${firstTab}" extraButtonSource="${section.extraButtonSource}">
        <div class="tab-container" align="center">
                <c:choose>
                    <c:when test="${section.compact}">
                        <table class="datatable-100 compact">
                            <kul:compactInquiryRowDisplay rows="${section.rows}" numberOfColumns="${section.numberOfColumns}" />
                        </table>
                    </c:when>
                    <c:otherwise>
                        <table class="standard">
                            <kul:inquiryRowDisplay rows="${section.rows}" numberOfColumns="${section.numberOfColumns}" />
                        </table>
                    </c:otherwise>
                </c:choose>
            </table>
        </div>
    </kul:tab>
</c:forEach>

<c:choose>
    <c:when test="${param.mode eq 'modal'}">
        <c:if test="${KualiForm.canExport}">
            <div class="modal-footer">
                <html:submit value="Export" styleClass="btn btn-default" property="methodToCall.export"
                             title="Perform Export" alt="Perform Export" onclick="excludeSubmitRestriction=true"/>
            </div>
        </c:if>
    </c:when>
    <c:otherwise>
        <kul:inquiryControls />
    </c:otherwise>
</c:choose>
