<%--

    The Kuali Financial System, a comprehensive financial management system for higher education.

    Copyright 2005-2023 Kuali, Inc.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.

--%>
<%@ include file="/jsp/sys/kfsTldHeader.jsp"%>

<c:set var="KualiForm" value="${DocumentQueueOperationForm}" scope="request"/>
<kul:page headerTitle="Document Queue Operation" lookup="false"
    headerMenuBar="" transactionalDocument="false" showDocumentInfo="false"
    htmlFormAction="DocumentQueueOperation" docTitle="Document Queue Operation">

  <html-el:html>
    <div class="msg-excol">
      <div class="left-errmsg">
        <kul:errors errorTitle="Errors found in Search Criteria:" />
        <jsp:include page="../WorkflowMessages.jsp" flush="true" />
      </div>
    </div>

    <html-el:form action="/DocumentQueueOperation.do">
      <div id="view_div">
        <kul:tabTop tabTitle="Operate On A Document" defaultOpen="true">
          <div class="tab-container">
            <kul:csrf />
            <table class="standard side-margins" style="margin-top: 25px;">
              <tr>
                <th align="right">
                  <div align="right">*Document ID:&nbsp;</div>
                </th>
                <td width="20%">
                    <html-el:hidden property="routeHeader.documentId" />
                    <html-el:text property="documentId" />
                </td>
                <td align="left">
                  <html:submit styleClass="btn btn-primary" property="methodToCall.getDocument" value="Get Document" />
                </td>
              </tr>
            </table>
          </div>
        </kul:tabTop>

        <c:if test="${DocumentQueueOperationForm.routeHeader.documentId != null && DocumentQueueOperationForm.routeHeader.documentId != ''}">
          <kul:tab tabTitle="Document Actions" defaultOpen="true">
            <div class="tab-container">
              <div style="padding: 30px; text-align: center; box-shadow: 0px 2px 0px 0px #F3F3F3;">
                <html:submit styleClass="btn btn-default" property="methodToCall.queueDocument" alt="Queue Document" value="Queue Document" />
                <html:submit styleClass="btn btn-default" property="methodToCall.indexSearchableAttributes" alt="Index Searchable Attributes" value="Index Searchable Attributes" />
                <html:submit styleClass="btn btn-default" property="methodToCall.queueDocumentRefresh" alt="Queue Document Refresh" value="Queue Document Refresh"/>
              </div>
            </div>
          </kul:tab>
          <div style="left: 40px;" id="globalbuttons" class="globalbuttons" role="navigation">
            <html:submit styleClass="btn btn-default" property="methodToCall.clear" alt="Clear" value="Clear"/>
          </div>
        </c:if>
      </div>
    </html-el:form>
  </html-el:html>
</kul:page>
