/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.dot;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.DefaultConsumer;
import org.codehaus.plexus.util.cli.StreamConsumer;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.GraphException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dot {
    private static final Logger logger = LoggerFactory.getLogger(Dot.class);
    public static final int SUCCESS = 0;

    public void fillInContext(GraphDescriptor gc, String content) {
        File dotFile = this.createDotFile(gc.getFile(), content);
        String type = this.getType(gc.getFile());
        gc.setDotFile(dotFile);
        gc.setOutputFormat(type);
    }

    protected String[] getArgs(GraphDescriptor context) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("-T" + context.getOutputFormat());
        args.add("-o" + context.getFile().getAbsolutePath());
        args.add(context.getDotFile().getAbsolutePath());
        return args.toArray(new String[args.size()]);
    }

    protected Commandline getCommandLine(GraphDescriptor context) {
        Commandline commandline = new Commandline();
        try {
            commandline.addSystemEnvironment();
        }
        catch (Exception exception) {
            // empty catch block
        }
        commandline.setExecutable(context.getExecutable());
        commandline.addArguments(this.getArgs(context));
        return commandline;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected int execute(Commandline commandLine, GraphDescriptor context) {
        try {
            DefaultConsumer stdout = new DefaultConsumer();
            DefaultConsumer stderr = new DefaultConsumer();
            int exitValue = CommandLineUtils.executeCommandLine((Commandline)commandLine, (StreamConsumer)stdout, (StreamConsumer)stderr);
            if (exitValue != 0) {
                if (!context.getIgnoreDotFailure().booleanValue()) throw new GraphException(this.getErrorMessage(commandLine, exitValue));
                logger.info("Ignoring failure of the 'dot' binary. Exit value=" + exitValue);
                return exitValue;
            } else {
                logger.debug(context.getFile().getPath());
            }
            return exitValue;
        }
        catch (CommandLineException e) {
            throw new GraphException(e);
        }
    }

    protected String getErrorMessage(Commandline commandLine, int exitValue) {
        String executable;
        String[] args = commandLine.getArguments();
        String s = executable = commandLine.getExecutable();
        for (String arg : args) {
            s = s + " " + arg;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Failed execution '" + s + "'");
        sb.append(" Exit value: '" + exitValue + "'");
        sb.append(" Is it installed? See: http://www.graphviz.org");
        return sb.toString();
    }

    public int execute(GraphDescriptor context) {
        int exitValue = -1;
        if (context.getExecuteDot().booleanValue()) {
            Commandline commandline = this.getCommandLine(context);
            exitValue = this.execute(commandline, context);
        } else {
            logger.info("Skip executing 'dot'");
        }
        if (!context.getKeepDotFile().booleanValue()) {
            context.getDotFile().delete();
        } else {
            logger.debug(context.getDotFile().getPath());
        }
        return exitValue;
    }

    protected File createDotFile(File graph, String content) {
        File dotFile = this.getDotFile(graph);
        try {
            FileUtils.write((File)dotFile, (CharSequence)content);
            return dotFile;
        }
        catch (IOException e) {
            throw new GraphException(e);
        }
    }

    protected String getType(File graph) {
        return FilenameUtils.getExtension((String)graph.getName());
    }

    protected File getDotFile(File graph) {
        File dir = graph.getParentFile();
        String path = dir.getAbsolutePath();
        String basename = FilenameUtils.getBaseName((String)graph.getName());
        String extension = "dot";
        String filename = path + File.separator + basename + "." + extension;
        return new File(filename);
    }
}

