/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.dot;

import java.util.ArrayList;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.Scope;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.pojo.Style;
import org.kuali.maven.plugins.graph.processor.StyleProcessor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.kuali.maven.plugins.graph.util.Counter;

public class EdgeGenerator {
    StyleProcessor sp = new StyleProcessor();
    Counter counter = new Counter(1);

    public void addEdge(Node<MavenContext> node, Edge edge) {
        MavenContext context = node.getObject();
        GraphNode graphNode = context.getGraphNode();
        if (graphNode.getEdges() == null) {
            graphNode.setEdges(new ArrayList<Edge>());
        }
        graphNode.getEdges().add(edge);
    }

    public Edge getParentChildEdge(Node<MavenContext> node) {
        GraphNode parent = ((MavenContext)((Node)node.getParent()).getObject()).getGraphNode();
        MavenContext context = node.getObject();
        GraphNode child = context.getGraphNode();
        boolean optional = context.isOptional();
        State state = context.getState();
        Scope scope = Scope.getScope(context.getArtifact().getScope());
        return this.getStyledEdge(parent, child, optional, scope, state);
    }

    public Edge getParentChildEdge(Node<MavenContext> node, Node<MavenContext> replacement, State state) {
        GraphNode parent = ((MavenContext)((Node)node.getParent()).getObject()).getGraphNode();
        MavenContext context = node.getObject();
        GraphNode child = replacement.getObject().getGraphNode();
        boolean optional = context.isOptional();
        Scope scope = Scope.getScope(context.getArtifact().getScope());
        return this.getStyledEdge(parent, child, optional, scope, state);
    }

    public Edge getParentChildEdge(Node<MavenContext> node, Node<MavenContext> replacement) {
        return this.getParentChildEdge(node, replacement, node.getObject().getState());
    }

    public Edge getStyledEdge(GraphNode parent, GraphNode child, boolean optional, Scope scope, State state) {
        Style style = this.sp.getStyle(scope, optional, state);
        int id = this.counter.increment();
        String label = TreeHelper.getRelationshipLabel(scope, optional, state);
        Edge edge = new Edge(parent, child);
        edge.setId(id);
        this.sp.copyStyleProperties(edge, style);
        edge.setLabel(label);
        return edge;
    }
}

