/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.dot;

import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.maven.plugins.graph.dot.html.CellAlign;
import org.kuali.maven.plugins.graph.dot.html.Font;
import org.kuali.maven.plugins.graph.dot.html.HtmlUtils;
import org.kuali.maven.plugins.graph.dot.html.Table;
import org.kuali.maven.plugins.graph.dot.html.TableCell;
import org.kuali.maven.plugins.graph.dot.html.TableRow;
import org.kuali.maven.plugins.graph.pojo.Direction;
import org.kuali.maven.plugins.graph.pojo.Display;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.Graph;
import org.kuali.maven.plugins.graph.pojo.GraphDecorator;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.LabelContext;
import org.kuali.maven.plugins.graph.pojo.NameValue;
import org.kuali.maven.plugins.graph.util.Helper;

public class GraphHelper {
    HtmlUtils htmlUtils = new HtmlUtils();
    public static final String DEFAULT_TYPE = "jar";

    public String getGraphTitle(GraphDescriptor context) {
        String title;
        String string = title = context.getShowTitle() != false ? context.getTitle() : "";
        if (!context.getShowLegend().booleanValue()) {
            return '\"' + title + '\"';
        }
        List<NameValue> labels = this.getLegendLabels(context);
        if (Helper.isEmpty(labels)) {
            return '\"' + title + '\"';
        }
        HtmlUtils htmlUtils = new HtmlUtils();
        Table table = this.getTitle(title, labels);
        return "<" + htmlUtils.toHtml(table) + ">";
    }

    protected List<NameValue> getLegendLabels(GraphDescriptor context) {
        ArrayList<NameValue> labels = new ArrayList<NameValue>();
        this.addLabel("includes", context.getIncludes(), labels);
        this.addLabel("excludes", context.getExcludes(), labels);
        this.addLabel("show", context.getShow(), labels);
        this.addLabel("hide", context.getHide(), labels);
        if (context.getDisplay() != Display.TREE) {
            this.addLabel("display", context.getDisplay().toString(), labels);
        }
        if (!context.getTransitive().booleanValue()) {
            this.addLabel("transitive", context.getTransitive() + "", labels);
        }
        if (context.getDepth() != null && context.getDepth() >= 0) {
            this.addLabel("depth", context.getDepth() + "", labels);
        }
        return labels;
    }

    protected void addLabel(String name, String value, List<NameValue> labels) {
        if (!Helper.isBlank(value)) {
            NameValue nv = new NameValue(name, value);
            labels.add(nv);
        }
    }

    protected String getLegendText(NameValue label, int padding) {
        StringBuilder sb = new StringBuilder();
        sb.append(StringUtils.leftPad((String)label.getName(), (int)padding, (String)" "));
        sb.append(" = ");
        sb.append(label.getValue());
        return sb.toString();
    }

    protected TableRow getLegendRow(NameValue label, Font font, int padding) {
        font.setContent(this.getLegendText(label, padding));
        TableCell cell = new TableCell(this.htmlUtils.toHtml(font));
        cell.setAlign(CellAlign.LEFT);
        return new TableRow(cell);
    }

    protected int getMaxNameLength(List<NameValue> labels) {
        int max = 0;
        for (NameValue label : labels) {
            int length = label.getName().length();
            if (length <= max) continue;
            max = length;
        }
        return max;
    }

    protected List<TableRow> getLegendRows(String title, List<NameValue> labels) {
        Font font = new Font("black", 10);
        font.setFace("Courier");
        font.setContent(" ");
        ArrayList<TableRow> rows = new ArrayList<TableRow>();
        if (!StringUtils.isBlank((String)title)) {
            rows.add(new TableRow(new TableCell(this.htmlUtils.toHtml(font))));
        }
        int padding = this.getMaxNameLength(labels);
        for (NameValue label : labels) {
            rows.add(this.getLegendRow(label, font, padding));
        }
        font.setContent(" ");
        rows.add(new TableRow(new TableCell(this.htmlUtils.toHtml(font))));
        return rows;
    }

    public Table getTitle(String title, List<NameValue> labels) {
        ArrayList<TableRow> rows = new ArrayList<TableRow>(this.getLegendRows(title, labels));
        TableCell titleCell = new TableCell(title);
        TableRow titleRow = new TableRow(titleCell);
        if (!StringUtils.isBlank((String)title)) {
            rows.add(0, titleRow);
        }
        Table table = new Table(rows);
        table.setBorder(0);
        table.setCellpadding(0);
        table.setCellspacing(0);
        return table;
    }

    public Graph getGraph(String title) {
        return this.getGraph(title, Direction.DEFAULT_DIRECTION, new ArrayList<GraphNode>(), new ArrayList<Edge>());
    }

    public Graph getGraph(String title, List<GraphNode> nodes) {
        return this.getGraph(title, Direction.DEFAULT_DIRECTION, nodes, new ArrayList<Edge>());
    }

    public Graph getGraph(String title, Direction direction, List<GraphNode> nodes, List<Edge> edges) {
        GraphDecorator decorator = new GraphDecorator(title, direction.name());
        return this.getGraph(decorator, nodes, edges);
    }

    public Graph getGraph(GraphDecorator decorator, List<GraphNode> nodes, List<Edge> edges) {
        Graph graph = new Graph();
        graph.setGraphDecorator(decorator);
        graph.setNodes(nodes);
        graph.setEdges(edges);
        return graph;
    }

    protected void add(List<String> list, String s, boolean show) {
        if (show && !Helper.isBlank(s)) {
            list.add(s);
        }
    }

    public String getLabel(Artifact a) {
        return this.getLabel(a, new LabelContext());
    }

    public String getLabel(Artifact a, LabelContext context) {
        boolean showType = context.isShowTypes() && !DEFAULT_TYPE.equalsIgnoreCase(a.getType());
        ArrayList<String> labelTokens = new ArrayList<String>();
        this.add(labelTokens, a.getGroupId(), context.isShowGroupIds());
        this.add(labelTokens, a.getArtifactId(), context.isShowArtifactIds());
        this.add(labelTokens, a.getType(), showType);
        this.add(labelTokens, a.getClassifier(), context.isShowClassifiers());
        this.add(labelTokens, a.getVersion(), context.isShowVersions());
        return this.getLabel(labelTokens);
    }

    public String getLabel(List<String> tokens) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tokens.size(); ++i) {
            if (i != 0) {
                sb.append("\\n");
            }
            sb.append(tokens.get(i));
        }
        return sb.toString();
    }
}

