/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.dot.html;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.beanutils.PropertyUtils;
import org.kuali.maven.plugins.graph.dot.html.HtmlTag;

public class HtmlUtils {
    protected boolean isSkipProperty(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof Collection) {
            return true;
        }
        return value instanceof HtmlTag;
    }

    public <T extends HtmlTag> T cloneAttributes(T element) {
        Map<String, ?> attributes = this.getAttributes(element);
        T newElement = this.newInstance(element);
        for (String property : attributes.keySet()) {
            Object value = attributes.get(property);
            this.setProperty(newElement, property, value);
        }
        return newElement;
    }

    protected <T> T newInstance(T object) {
        try {
            return (T)object.getClass().newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Map<String, ?> getAttributes(HtmlTag element) {
        Map<String, ?> description = this.describe(element);
        ArrayList<String> properties = new ArrayList<String>(description.keySet());
        for (String property : properties) {
            Object value = description.get(property);
            if (!this.isSkipProperty(value)) continue;
            description.remove(property);
        }
        description.remove("class");
        description.remove("name");
        description.remove("content");
        return description;
    }

    public String toHtml(List<? extends HtmlTag> tags) {
        if (tags == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (HtmlTag htmlTag : tags) {
            sb.append(this.toHtml(htmlTag));
        }
        return sb.toString();
    }

    public String toHtml(HtmlTag tag) {
        String name = tag.getName();
        String content = tag.getContent();
        Map<String, ?> attributeMap = this.getAttributes(tag);
        String attributes = this.toHtml(attributeMap);
        if (content == null) {
            return "<" + name + attributes + "/>";
        }
        return "<" + name + attributes + ">" + content + "</" + name + ">";
    }

    public String toHtml(Map<String, ?> attributes) {
        if (attributes.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String key : attributes.keySet()) {
            String value = attributes.get(key).toString();
            String name = this.getTranslatedAttributeName(key);
            sb.append(name + "=" + this.quote(value) + " ");
        }
        sb.replace(sb.lastIndexOf(" "), sb.length(), "");
        return " " + sb.toString();
    }

    protected String getTranslatedAttributeName(String name) {
        if (name.equals("pointSize")) {
            return "point-size";
        }
        if (name.equals("rowCount")) {
            return "rows";
        }
        return name;
    }

    public String quote(String s) {
        return '\"' + s + '\"';
    }

    public Map<String, ?> describe(HtmlTag element) {
        try {
            return new TreeMap(PropertyUtils.describe((Object)element));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void setProperty(HtmlTag element, String property, Object value) {
        try {
            PropertyUtils.setProperty((Object)element, (String)property, (Object)value);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

