/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.filter;

import org.kuali.maven.plugins.graph.filter.NodeFilter;
import org.kuali.maven.plugins.graph.tree.Node;

public class DepthFilter<T>
implements NodeFilter<T> {
    public static final int INFINITE = Integer.MAX_VALUE;
    public static final int NONE = -1;
    public static final int ROOT = 0;
    int maxDepth;

    public DepthFilter() {
        this(Integer.MAX_VALUE);
    }

    public DepthFilter(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    @Override
    public boolean isMatch(Node<T> node) {
        return node.getLevel() <= this.maxDepth;
    }

    public int getMaxDepth() {
        return this.maxDepth;
    }

    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
    }

    public static final <T> DepthFilter<T> infinite() {
        return new DepthFilter<T>(Integer.MAX_VALUE);
    }

    public static final <T> DepthFilter<T> none() {
        return new DepthFilter<T>(-1);
    }

    public static final <T> DepthFilter<T> root() {
        return new DepthFilter<T>(0);
    }
}

