/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.filter;

import java.util.ArrayList;
import java.util.List;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.filter.FilterException;
import org.kuali.maven.plugins.graph.filter.MatchCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterChain<T>
implements Filter<T> {
    private static final Logger logger = LoggerFactory.getLogger(FilterChain.class);
    public static final MatchCondition DEFAULT_MATCH_CONDITION = MatchCondition.ALL;
    public static final boolean DEFAULT_RETURN_VALUE = true;
    boolean defaultReturnValue;
    MatchCondition condition;
    List<? extends Filter<T>> filters;

    public FilterChain() {
        this(new ArrayList());
    }

    public FilterChain(List<? extends Filter<T>> filters) {
        this(filters, DEFAULT_MATCH_CONDITION);
    }

    public FilterChain(List<? extends Filter<T>> filters, MatchCondition condition) {
        this(filters, condition, true);
    }

    public FilterChain(List<? extends Filter<T>> filters, MatchCondition condition, boolean defaultReturnValue) {
        this.filters = filters;
        this.condition = condition;
        this.defaultReturnValue = defaultReturnValue;
    }

    @Override
    public boolean isMatch(T element) {
        if (this.filters == null || this.filters.size() == 0) {
            return this.defaultReturnValue;
        }
        for (Filter<T> filter : this.filters) {
            boolean match = filter.isMatch(element);
            if (match && this.condition == MatchCondition.ANY) {
                return true;
            }
            if (match || this.condition != MatchCondition.ALL) continue;
            return false;
        }
        switch (this.condition) {
            case ALL: {
                logger.debug("all matched");
                return true;
            }
            case ANY: {
                logger.debug("none matched");
                return false;
            }
        }
        throw new FilterException("Unknown condition " + (Object)((Object)this.condition));
    }

    public MatchCondition getCondition() {
        return this.condition;
    }

    public void setCondition(MatchCondition condition) {
        this.condition = condition;
    }

    public List<? extends Filter<T>> getFilters() {
        return this.filters;
    }

    public void setFilters(List<? extends Filter<T>> filters) {
        this.filters = filters;
    }
}

