/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.filter;

import java.util.List;
import org.kuali.maven.plugins.graph.collector.TokenCollector;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.filter.IncludeExcludeFilter;
import org.kuali.maven.plugins.graph.filter.MatchEverythingFilter;
import org.kuali.maven.plugins.graph.filter.MatchNothingFilter;
import org.kuali.maven.plugins.graph.filter.PatternsFilter;
import org.kuali.maven.plugins.graph.util.Helper;

public class Filters {
    public <T> Filter<T> getIncludeExcludePatternFilter(String includes, String excludes, TokenCollector<T> collector) {
        Filter<T> include = this.getIncludePatternFilter(includes, collector);
        Filter<T> exclude = this.getExcludePatternFilter(excludes, collector);
        return new IncludeExcludeFilter<T>(include, exclude);
    }

    public <T> Filter<T> getIncludePatternFilter(String includes, TokenCollector<T> collector) {
        Filter<T> matchEverything = Filters.matchEverything();
        return this.getPatternFilter(includes, matchEverything, collector);
    }

    public <T> Filter<T> getExcludePatternFilter(String excludes, TokenCollector<T> collector) {
        Filter<T> matchNothing = Filters.matchNothing();
        return this.getPatternFilter(excludes, matchNothing, collector);
    }

    public <T> Filter<T> getPatternFilter(String csv, Filter<T> defaultFilter, TokenCollector<T> collector) {
        List<String> patterns = Helper.splitAndTrimCSVToList(csv);
        if (Helper.isEmpty(patterns)) {
            return defaultFilter;
        }
        return new PatternsFilter<T>(patterns, collector);
    }

    public static final <T> Filter<T> matchNothing() {
        return new MatchNothingFilter();
    }

    public static final <T> Filter<T> matchEverything() {
        return new MatchEverythingFilter();
    }
}

