/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.filter;

import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.filter.Filters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IncludeExcludeFilter<T>
implements Filter<T> {
    private static final Logger logger = LoggerFactory.getLogger(IncludeExcludeFilter.class);
    Filter<T> include;
    Filter<T> exclude;

    public IncludeExcludeFilter() {
        this(Filters.matchEverything(), Filters.matchNothing());
    }

    public IncludeExcludeFilter(Filter<T> include, Filter<T> exclude) {
        this.include = include;
        this.exclude = exclude;
    }

    @Override
    public boolean isMatch(T element) {
        boolean included = this.include.isMatch(element);
        boolean excluded = this.exclude.isMatch(element);
        logger.debug("included={} excluded={}", (Object)included, (Object)excluded);
        return included && !excluded;
    }

    public Filter<T> getInclude() {
        return this.include;
    }

    public void setInclude(Filter<T> include) {
        this.include = include;
    }

    public Filter<T> getExclude() {
        return this.exclude;
    }

    public void setExclude(Filter<T> exclude) {
        this.exclude = exclude;
    }
}

