/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.filter;

import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.kuali.maven.plugins.graph.collector.TokenCollector;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.filter.FilterException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PatternsFilter<T>
implements Filter<T> {
    private static final Logger logger = LoggerFactory.getLogger(PatternsFilter.class);
    public static final String DEFAULT_DELIMITER = ":";
    public static final String DEFAULT_WILDCARD = "*";
    String delimiter = ":";
    String wildcard = "*";
    List<String> patterns;
    TokenCollector<T> collector;

    public PatternsFilter() {
        this(null);
    }

    public PatternsFilter(List<String> patterns) {
        this(patterns, null);
    }

    public PatternsFilter(List<String> patterns, TokenCollector<T> collector) {
        this.patterns = patterns;
        this.collector = collector;
    }

    @Override
    public boolean isMatch(T object) {
        if (this.isEmpty(this.patterns)) {
            return true;
        }
        List<String> tokens = this.collector.getTokens(object);
        logger.debug("tokens size={}", (Object)tokens.size());
        this.validate(tokens, this.patterns);
        return this.isAtLeastOneMatch(tokens, this.patterns);
    }

    protected boolean isAtLeastOneMatch(List<String> tokens, List<String> patterns) {
        for (String pattern : patterns) {
            if (!this.isMatch(tokens, pattern)) continue;
            return true;
        }
        logger.debug("no match");
        return false;
    }

    protected boolean isMatch(List<String> tokens, String pattern) {
        String[] patternTokens = pattern.split(this.delimiter);
        for (int i = 0; i < patternTokens.length; ++i) {
            String token = tokens.get(i);
            if (this.isMatch(token, patternTokens[i])) continue;
            logger.debug("{} does not match {}", (Object)token, (Object)patternTokens[i]);
            return false;
        }
        return true;
    }

    protected boolean isMatch(String token, String pattern) {
        if (this.wildcard.equals(pattern) || pattern.length() == 0) {
            return true;
        }
        if (token == null) {
            return false;
        }
        if (pattern.startsWith(this.wildcard) && pattern.endsWith(this.wildcard)) {
            String contains = pattern.substring(1, pattern.length() - 1);
            return token.indexOf(contains) != -1;
        }
        if (pattern.startsWith(this.wildcard)) {
            String suffix = pattern.substring(1, pattern.length());
            return token.endsWith(suffix);
        }
        if (pattern.endsWith(this.wildcard)) {
            String prefix = pattern.substring(0, pattern.length() - 1);
            return token.startsWith(prefix);
        }
        if (pattern.startsWith("[") || pattern.startsWith("(")) {
            return this.isVersionIncludedInRange(token, pattern);
        }
        return token.equals(pattern);
    }

    protected boolean isVersionIncludedInRange(String version, String range) {
        try {
            VersionRange versionRange = VersionRange.createFromVersionSpec((String)range);
            DefaultArtifactVersion artifactVersion = new DefaultArtifactVersion(version);
            return versionRange.containsVersion((ArtifactVersion)artifactVersion);
        }
        catch (InvalidVersionSpecificationException e) {
            throw new FilterException(e);
        }
    }

    protected boolean isEmpty(Collection<?> c) {
        return c == null || c.size() == 0;
    }

    protected boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    protected void validate(List<String> artifactTokens, List<String> patterns) {
        for (String pattern : patterns) {
            if (this.isValid(artifactTokens, pattern)) continue;
            throw new FilterException("Invalid pattern: '" + pattern + "'");
        }
    }

    protected boolean isValid(List<String> artifactTokens, String pattern) {
        if (this.isBlank(pattern)) {
            return false;
        }
        String[] tokens = pattern.split(this.delimiter);
        int length = tokens.length;
        return length <= artifactTokens.size();
    }

    public List<String> getPatterns() {
        return this.patterns;
    }

    public void setPatterns(List<String> patterns) {
        this.patterns = patterns;
    }

    public TokenCollector<T> getCollector() {
        return this.collector;
    }

    public void setCollector(TokenCollector<T> collector) {
        this.collector = collector;
    }
}

