/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.mojo;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilder;
import org.apache.maven.shared.dependency.tree.DependencyTreeBuilderException;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.maven.plugins.graph.collector.ArtifactIdTokenCollector;
import org.kuali.maven.plugins.graph.collector.MavenContextTokenCollector;
import org.kuali.maven.plugins.graph.dot.Dot;
import org.kuali.maven.plugins.graph.dot.GraphHelper;
import org.kuali.maven.plugins.graph.dot.StringGenerator;
import org.kuali.maven.plugins.graph.filter.ArtifactFilterWrapper;
import org.kuali.maven.plugins.graph.filter.DepthFilter;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.filter.Filters;
import org.kuali.maven.plugins.graph.filter.IncludeExcludeFilter;
import org.kuali.maven.plugins.graph.filter.MatchCondition;
import org.kuali.maven.plugins.graph.filter.MavenContextFilterWrapper;
import org.kuali.maven.plugins.graph.filter.NodeFilter;
import org.kuali.maven.plugins.graph.filter.NodeFilterChain;
import org.kuali.maven.plugins.graph.filter.ReverseNodeFilter;
import org.kuali.maven.plugins.graph.pojo.Category;
import org.kuali.maven.plugins.graph.pojo.Conflicts;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.Graph;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.GraphException;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.Layout;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.MojoContext;
import org.kuali.maven.plugins.graph.pojo.Row;
import org.kuali.maven.plugins.graph.pojo.Scope;
import org.kuali.maven.plugins.graph.processor.CascadeOptionalProcessor;
import org.kuali.maven.plugins.graph.processor.FlatEdgeProcessor;
import org.kuali.maven.plugins.graph.processor.HideConflictsProcessor;
import org.kuali.maven.plugins.graph.processor.HideDuplicatesProcessor;
import org.kuali.maven.plugins.graph.processor.LabelProcessor;
import org.kuali.maven.plugins.graph.processor.LinkedEdgeProcessor;
import org.kuali.maven.plugins.graph.processor.PathDisplayProcessor;
import org.kuali.maven.plugins.graph.processor.PathTreeDisplayProcessor;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.processor.ReduceClutterProcessor;
import org.kuali.maven.plugins.graph.processor.SanitizingProcessor;
import org.kuali.maven.plugins.graph.processor.ShowMetadataProcessor;
import org.kuali.maven.plugins.graph.processor.StyleProcessor;
import org.kuali.maven.plugins.graph.processor.TreeDisplayProcessor;
import org.kuali.maven.plugins.graph.processor.ValidatingProcessor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.kuali.maven.plugins.graph.util.Counter;
import org.kuali.maven.plugins.graph.util.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MojoHelper {
    private static final Logger logger = LoggerFactory.getLogger(MojoHelper.class);
    Filters filters = new Filters();

    public Filter<Node<MavenContext>> getIncludeExcludeFilter(GraphDescriptor descriptor) {
        NodeFilter<MavenContext> include = this.getIncludeFilter(descriptor);
        NodeFilter<MavenContext> exclude = this.getExcludeFilter(descriptor);
        return new IncludeExcludeFilter<MavenContext>(include, exclude);
    }

    public void categories(MojoContext mc, GraphDescriptor gc, List<Category> categories) {
        if (mc.isSkip()) {
            logger.info("Skipping execution");
            return;
        }
        if (Helper.isEmpty(categories) && !mc.isGenerateDefaultGraphs()) {
            logger.info("No categories");
            return;
        }
        if (mc.isGenerateDefaultGraphs()) {
            categories.addAll(0, this.getDefaultCategories(gc));
        }
        int count = 0;
        for (Category category : categories) {
            for (Row row : category.getRows()) {
                row.setCategory(category);
                this.fillInDescriptors(gc, row.getDescriptors(), mc.getOutputDir(), row);
                List<GraphDescriptor> executed = this.execute(mc, gc, row.getDescriptors());
                count += executed.size();
                row.setDescriptors(executed);
            }
        }
        if (count == 0) {
            logger.info("No graphs to generate");
        }
    }

    public List<GraphDescriptor> executeMulti(MojoContext mc, GraphDescriptor gd, List<GraphDescriptor> descriptors) {
        try {
            if (mc.isSkip()) {
                logger.info("Skipping execution");
                return null;
            }
            if (Helper.isEmpty(descriptors) && !mc.isGenerateDefaultGraphs()) {
                logger.info("No descriptors");
                return null;
            }
            if (mc.isGenerateDefaultGraphs()) {
                descriptors.addAll(0, this.getDefaultDescriptors(mc, gd));
            }
            this.fillInDescriptors(gd, descriptors, mc.getOutputDir(), null);
            ArrayList<GraphDescriptor> executedGraphs = new ArrayList<GraphDescriptor>();
            int count = 0;
            for (GraphDescriptor descriptor : descriptors) {
                GraphDescriptor executed = this.execute(mc, descriptor);
                if (executed == null) continue;
                executedGraphs.add(executed);
                ++count;
            }
            if (count == 0) {
                logger.info("No graphs to generate");
            }
            return executedGraphs;
        }
        catch (Exception e) {
            throw new GraphException(e);
        }
    }

    public List<GraphDescriptor> execute(MojoContext mc, GraphDescriptor gd, List<GraphDescriptor> descriptors) {
        try {
            if (mc.isSkip()) {
                logger.info("Skipping execution");
                return null;
            }
            if (Helper.isEmpty(descriptors)) {
                logger.info("No descriptors");
                return null;
            }
            ArrayList<GraphDescriptor> executedGraphs = new ArrayList<GraphDescriptor>();
            for (GraphDescriptor descriptor : descriptors) {
                GraphDescriptor executed = this.execute(mc, descriptor);
                if (executed == null) continue;
                executedGraphs.add(executed);
            }
            return executedGraphs;
        }
        catch (Exception e) {
            throw new GraphException(e);
        }
    }

    protected void fillInDescriptors(GraphDescriptor gd, List<GraphDescriptor> gds, File outputDir, Row row) {
        gd.setRow(row);
        logger.debug("default output format={}", (Object)gd.getOutputFormat());
        Counter counter = new Counter(1);
        for (GraphDescriptor desc : gds) {
            String relativeFilename;
            Helper.copyPropertiesIfNull(desc, gd);
            if (desc.getName() == null) {
                desc.setName(counter.increment() + "");
            }
            if (desc.getTransitive() == null) {
                desc.setTransitive(true);
            }
            if (desc.getLayout() == null) {
                desc.setLayout(Layout.LINKED);
            }
            if ((relativeFilename = desc.getRelativeFilename()) == null) {
                String path = "";
                String filename = this.getFilename(desc);
                if (row != null) {
                    path = this.getPathFromRow(desc.getRow());
                }
                String string = relativeFilename = StringUtils.isBlank((String)path) ? filename : path + "/" + filename;
            }
            if (desc.getFile() != null) continue;
            File file = new File(outputDir, relativeFilename);
            desc.setFile(file);
        }
    }

    protected List<GraphDescriptor> getDefaultDescriptors(MojoContext mc, GraphDescriptor gd) {
        ArrayList<GraphDescriptor> descriptors = new ArrayList<GraphDescriptor>();
        List<Category> categories = this.getDefaultCategories(gd);
        for (Category category : categories) {
            for (Row row : category.getRows()) {
                descriptors.addAll(row.getDescriptors());
                this.fillInDescriptors(gd, row.getDescriptors(), mc.getOutputDir(), row);
            }
        }
        return descriptors;
    }

    protected List<Category> getDefaultCategories(GraphDescriptor gd) {
        ArrayList<Category> categories = new ArrayList<Category>();
        categories.add(this.getCategory(gd, false));
        categories.add(this.getCategory(gd, true));
        return categories;
    }

    protected String getPathFromRow(Row row) {
        StringBuilder sb = new StringBuilder();
        sb.append(row.getCategory().getName());
        sb.append("/");
        sb.append(row.getName());
        return sb.toString();
    }

    protected String getFilename(GraphDescriptor gd) {
        StringBuilder sb = new StringBuilder();
        sb.append(gd.getName());
        sb.append(".");
        sb.append(gd.getOutputFormat());
        return sb.toString();
    }

    protected String getRelativeFilename(GraphDescriptor gd) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPathFromRow(gd.getRow()));
        sb.append("/");
        sb.append(this.getFilename(gd));
        return sb.toString();
    }

    protected Category getCategory(GraphDescriptor gd, boolean transitive) {
        String name = this.getTransitiveLabel(transitive);
        Category c = new Category(name);
        c.setDescription(this.getDescription(transitive));
        c.setRows(this.getRows(gd, transitive, c));
        return c;
    }

    protected String getTransitiveLabel(boolean transitive) {
        return transitive ? "transitive" : "direct";
    }

    protected String getDescription(Scope scope) {
        if (scope == null) {
            return "These are the dependencies of the project for all scopes.";
        }
        switch (scope) {
            case COMPILE: {
                return "These dependencies are required for compilation.  They are available in all classpaths of the project and are also propagated as transitive dependencies to projects that depend on this project";
            }
            case IMPORT: {
                return "This scope is only used on a dependency of type pom in the <dependencyManagement> section. It indicates that the specified POM should be replaced with the dependencies in that POM's <dependencyManagement> section";
            }
            case PROVIDED: {
                return "Similar to compile, but with the expectation that the JDK or a container will provide the dependency at runtime.  These dependencies are only available on the compilation and test classpaths, and are not transitive.";
            }
            case RUNTIME: {
                return "These dependencies are not required for compilation, but are for execution. They are in the runtime classpath (eg WEB-INF/lib) and test classpath, but not the compile classpath.";
            }
            case SYSTEM: {
                return "This scope is similar to provided except that you have to provide the JAR which contains it explicitly. The artifact must always be available and is not looked up in a repository.";
            }
            case TEST: {
                return "These dependencies are only required to compile and run unit tests for the application";
            }
        }
        throw new IllegalArgumentException("Unknown scope " + (Object)((Object)scope));
    }

    protected String getDescription(boolean transitive) {
        if (transitive) {
            return "These are the dependencies declared in this project's pom plus any transitive dependencies of those dependencies.";
        }
        return "These are the dependencies declared in this project's pom";
    }

    protected String getScopeLabel(Scope scope) {
        return scope == null ? "all" : scope.toString();
    }

    protected List<Row> getRows(GraphDescriptor gd, boolean transitive, Category category) {
        ArrayList<Row> rows = new ArrayList<Row>();
        Row any = new Row(this.getScopeLabel(null));
        any.setCategory(category);
        any.setDescriptors(this.getDescriptors(gd, any, transitive, null));
        any.setDescription(this.getDescription(null));
        rows.add(any);
        for (Scope scope : Scope.values()) {
            Row row = new Row(this.getScopeLabel(scope));
            row.setCategory(category);
            row.setDescription(this.getDescription(scope));
            row.setDescriptors(this.getDescriptors(gd, row, transitive, scope));
            rows.add(row);
        }
        return rows;
    }

    protected List<GraphDescriptor> getDescriptors(GraphDescriptor gd, Row row, boolean transitive, Scope scope) {
        ArrayList<GraphDescriptor> descriptors = new ArrayList<GraphDescriptor>();
        for (Layout layout : Layout.values()) {
            descriptors.add(this.getDescriptor(gd, row, transitive, scope, layout));
        }
        return descriptors;
    }

    protected GraphDescriptor getDescriptor(GraphDescriptor gd, Row row, boolean transitive, Scope scope, Layout layout) {
        GraphDescriptor descriptor = Helper.copyProperties(GraphDescriptor.class, gd);
        descriptor.setShow(scope == null ? null : scope.toString());
        descriptor.setTransitive(transitive);
        descriptor.setName(layout.toString().toLowerCase());
        descriptor.setLayout(layout);
        descriptor.setRow(row);
        return descriptor;
    }

    public GraphDescriptor execute(MojoContext mc, GraphDescriptor gc) {
        if (mc.isSkip()) {
            logger.info("Skipping execution");
            return null;
        }
        try {
            Node<MavenContext> tree = this.getProcessedTree(mc, gc);
            Graph graph = this.getGraph(tree, mc, gc);
            if (this.isEmptyGraph(graph) && Boolean.TRUE.equals(gc.getSkipEmptyGraphs())) {
                logger.debug("Skipping empty graph");
                return null;
            }
            String content = this.getDotFileContent(graph);
            Dot dot = new Dot();
            dot.fillInContext(gc, content);
            int exitValue = dot.execute(gc);
            if (exitValue == 0) {
                logger.info(gc.getFile().getPath());
                return gc;
            }
            return null;
        }
        catch (Exception e) {
            throw new GraphException(e);
        }
    }

    protected boolean isEmptyGraph(Graph graph) {
        int count = 0;
        List<GraphNode> nodes = graph.getNodes();
        for (GraphNode node : nodes) {
            if (node.isHidden()) continue;
            ++count;
        }
        return count <= 1;
    }

    protected String getDotFileContent(Graph graph) {
        return new StringGenerator().getString(graph);
    }

    public DependencyNode getMavenTree(MojoContext c) {
        try {
            DependencyTreeBuilder builder = c.getTreeBuilder();
            return builder.buildDependencyTree(c.getProject(), c.getLocalRepository(), c.getArtifactFactory(), c.getArtifactMetadataSource(), null, c.getArtifactCollector());
        }
        catch (DependencyTreeBuilderException e) {
            throw new GraphException(e);
        }
    }

    protected List<Processor> getProcessors(GraphDescriptor gd, boolean verbose) {
        ArrayList<Processor> processors = new ArrayList<Processor>();
        processors.add(new LabelProcessor(gd));
        if (verbose) {
            processors.add(new ShowMetadataProcessor());
        }
        processors.add(this.getDisplayProcessor(gd));
        processors.add(new StyleProcessor());
        processors.addAll(this.getEdgeProcessors(gd));
        if (!Boolean.TRUE.equals(gd.getShowDuplicates())) {
            processors.add(new HideDuplicatesProcessor());
        }
        return processors;
    }

    protected Processor getDisplayProcessor(GraphDescriptor gd) {
        switch (gd.getDisplay()) {
            case PATH: {
                return new PathDisplayProcessor(gd, false);
            }
            case TREE: {
                return new TreeDisplayProcessor(gd);
            }
            case PT: {
                return new PathTreeDisplayProcessor(gd);
            }
        }
        throw new IllegalStateException("Unknown filter type " + (Object)((Object)gd.getDisplay()));
    }

    protected Node<MavenContext> getProcessedTree(MojoContext mc, GraphDescriptor gc) {
        TreeHelper helper = new TreeHelper();
        if (mc.getMavenTree() == null) {
            DependencyNode mavenTree = this.getMavenTree(mc);
            mc.setMavenTree(mavenTree);
        }
        if (mc.getSanitizedTree() == null) {
            Node<MavenContext> tree = helper.getTree(mc.getMavenTree());
            this.sanitizeTree(tree, gc);
            mc.setSanitizedTree(tree);
        }
        Node<MavenContext> copy = helper.copy(mc.getSanitizedTree());
        List<Processor> processors = this.getProcessors(gc, mc.isVerbose());
        for (Processor processor : processors) {
            logger.debug("processor={}", processor.getClass());
            processor.process(copy);
        }
        return copy;
    }

    protected void sanitizeTree(Node<MavenContext> node, GraphDescriptor gd) {
        new ValidatingProcessor().process(node);
        new SanitizingProcessor().process(node);
        if (Boolean.TRUE.equals(gd.getCascadeOptional())) {
            new CascadeOptionalProcessor().process(node);
        }
    }

    public Graph getGraph(Node<MavenContext> tree, MojoContext mc, GraphDescriptor gc) {
        GraphHelper gh = new GraphHelper();
        TreeHelper helper = new TreeHelper();
        List<GraphNode> nodes = helper.getGraphNodes(tree);
        List<Edge> edges = helper.getEdges(tree);
        if (mc.isVerbose()) {
            helper.show(nodes, edges);
        }
        String title = gh.getGraphTitle(gc);
        return gh.getGraph(title, gc.getDirection(), nodes, edges);
    }

    protected List<? extends Processor> getEdgeProcessors(GraphDescriptor gd) {
        Conflicts conflicts = gd.getConflicts();
        ArrayList<Processor> processors = new ArrayList<Processor>();
        HideConflictsProcessor conflictsProcessor = new HideConflictsProcessor(gd);
        switch (gd.getLayout()) {
            case LINKED: {
                processors.add(new LinkedEdgeProcessor());
                if (conflicts == Conflicts.LABEL) {
                    logger.debug("labeling conflicts");
                    processors.add(new ReduceClutterProcessor());
                    processors.add(conflictsProcessor);
                } else if (conflicts == Conflicts.SHOW) {
                    logger.debug("showing conflicts");
                    processors.add(new ReduceClutterProcessor());
                } else if (conflicts == Conflicts.IGNORE) {
                    logger.debug("ignoring conflicts");
                    processors.add(conflictsProcessor);
                    processors.add(new ReduceClutterProcessor());
                }
                return processors;
            }
            case FLAT: {
                processors.add(new FlatEdgeProcessor());
                if (conflicts == Conflicts.LABEL) {
                    logger.debug("labeling conflicts");
                    processors.add(conflictsProcessor);
                } else if (conflicts == Conflicts.SHOW) {
                    logger.debug("showing conflicts");
                } else if (conflicts == Conflicts.IGNORE) {
                    processors.add(conflictsProcessor);
                    logger.debug("ignoring conflicts");
                }
                return processors;
            }
        }
        throw new IllegalStateException("Layout style " + (Object)((Object)gd.getLayout()) + " is unknown");
    }

    protected NodeFilter<MavenContext> getShowFilter(GraphDescriptor gc) {
        MavenContextTokenCollector collector = new MavenContextTokenCollector();
        Filter<MavenContext> filter = this.filters.getIncludePatternFilter(gc.getShow(), collector);
        return new MavenContextFilterWrapper(filter);
    }

    protected NodeFilter<MavenContext> getHideFilter(GraphDescriptor gc) {
        MavenContextTokenCollector collector = new MavenContextTokenCollector();
        Filter<MavenContext> filter = this.filters.getExcludePatternFilter(gc.getHide(), collector);
        return new MavenContextFilterWrapper(filter);
    }

    public NodeFilter<MavenContext> getIncludeFilter(GraphDescriptor gc) {
        ArtifactIdTokenCollector collector = new ArtifactIdTokenCollector();
        Filter<Artifact> filter = this.filters.getIncludePatternFilter(gc.getIncludes(), collector);
        ArtifactFilterWrapper artifactFilter = new ArtifactFilterWrapper(filter);
        ArrayList<NodeFilter<MavenContext>> filters = new ArrayList<NodeFilter<MavenContext>>();
        NodeFilter<MavenContext> artifactQualifierFilter = this.getShowFilter(gc);
        filters.add(artifactQualifierFilter);
        filters.add(artifactFilter);
        return new NodeFilterChain<MavenContext>((List<Filter<Node<MavenContext>>>)filters, MatchCondition.ALL, true);
    }

    public NodeFilter<MavenContext> getExcludeFilter(GraphDescriptor gc) {
        ArtifactIdTokenCollector collector = new ArtifactIdTokenCollector();
        Filter<Artifact> filter = this.filters.getExcludePatternFilter(gc.getExcludes(), collector);
        ArtifactFilterWrapper artifactFilter = new ArtifactFilterWrapper(filter);
        ReverseNodeFilter depthFilter = new ReverseNodeFilter(this.getDepthFilter(gc));
        NodeFilter<MavenContext> artifactQualifierFilter = this.getHideFilter(gc);
        ArrayList<NodeFilter<MavenContext>> filters = new ArrayList<NodeFilter<MavenContext>>();
        filters.add(artifactQualifierFilter);
        filters.add(artifactFilter);
        filters.add(depthFilter);
        return new NodeFilterChain<MavenContext>((List<Filter<Node<MavenContext>>>)filters, MatchCondition.ANY, false);
    }

    protected DepthFilter<MavenContext> getDepthFilter(GraphDescriptor gc) {
        int maxDepth = gc.getTransitive() != false ? Integer.MAX_VALUE : 1;
        maxDepth = gc.getDepth() != null && gc.getDepth() >= 0 ? gc.getDepth() : maxDepth;
        return new DepthFilter<MavenContext>(maxDepth);
    }
}

