/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.mojo;

import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.maven.reporting.MavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.kuali.maven.plugins.graph.mojo.MojoHelper;
import org.kuali.maven.plugins.graph.mojo.MultiMojo;
import org.kuali.maven.plugins.graph.pojo.Category;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.MojoContext;
import org.kuali.maven.plugins.graph.pojo.Row;
import org.kuali.maven.plugins.graph.util.Helper;

public class ReportMojo
extends MultiMojo
implements MavenReport {
    private static final String FS = System.getProperty("file.separator");
    private File reportOutputDirectory;
    private String subDirectory;
    private List<Category> categories;

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.setOutputDir(new File(this.reportOutputDirectory + FS + this.subDirectory));
        MojoContext mc = Helper.copyProperties(MojoContext.class, (Object)this);
        GraphDescriptor gd = Helper.copyProperties(GraphDescriptor.class, (Object)this);
        MojoHelper helper = new MojoHelper();
        if (this.isSkip()) {
            this.categories = Collections.emptyList();
            this.getLog().info((CharSequence)"Skipping graphs");
        } else {
            this.categories = Helper.toEmptyList(this.categories);
            helper.categories(mc, gd, this.categories);
        }
        this.doHead(sink);
        this.doBody(sink, this.categories);
        sink.flush();
        sink.close();
    }

    protected void doBody(Sink sink, List<Category> categories) {
        sink.body();
        sink.section1();
        sink.sectionTitle1();
        sink.text("Project Dependency Graphs");
        sink.sectionTitle1_();
        if (this.isEmpty(categories)) {
            sink.text("No graphs to display");
        } else {
            for (Category category : categories) {
                this.doCategory(sink, category);
            }
        }
        sink.section1_();
        sink.body_();
    }

    protected void doCategory(Sink sink, Category category) {
        if (this.isEmpty(category)) {
            return;
        }
        sink.section2();
        this.doCategoryHeader(sink, category);
        sink.table();
        this.doTableHeader(sink);
        for (Row row : category.getRows()) {
            this.doRow(sink, row);
        }
        sink.table_();
        sink.section2_();
    }

    protected void doCategoryHeader(Sink sink, Category category) {
        sink.sectionTitle2();
        sink.text(category.getName());
        sink.sectionTitle2_();
        sink.text(category.getDescription());
        sink.lineBreak();
        sink.lineBreak();
    }

    protected void doTableHeader(Sink sink) {
        sink.tableRow();
        sink.tableHeaderCell();
        sink.text("Type");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Graphs");
        sink.tableHeaderCell_();
        sink.tableHeaderCell();
        sink.text("Description");
        sink.tableHeaderCell_();
        sink.tableRow_();
    }

    protected void doRow(Sink sink, Row row) {
        if (this.isEmpty(row)) {
            return;
        }
        sink.tableRow();
        sink.tableCell();
        sink.text(row.getName());
        sink.tableCell_();
        sink.tableCell();
        this.doDescriptors(sink, row.getDescriptors());
        sink.tableCell_();
        sink.tableCell();
        sink.text(row.getDescription());
        sink.tableCell_();
        sink.tableRow_();
    }

    protected void doDescriptors(Sink sink, List<GraphDescriptor> gds) {
        for (int i = 0; i < gds.size(); ++i) {
            if (i != 0) {
                sink.text(",");
                sink.nonBreakingSpace();
            }
            this.doLink(sink, gds.get(i));
        }
    }

    protected void doLink(Sink sink, GraphDescriptor gd) {
        MojoHelper helper = new MojoHelper();
        String href = this.subDirectory + "/" + helper.getRelativeFilename(gd);
        sink.link(href);
        sink.text(gd.getName());
        sink.link_();
    }

    protected void doHead(Sink sink) {
        sink.head();
        sink.title();
        sink.text("Project Dependency Graphs");
        sink.title_();
        sink.head_();
    }

    public String getOutputName() {
        return "dependency-graphs";
    }

    public String getCategoryName() {
        return "Project Info";
    }

    public String getName(Locale locale) {
        return "Dependency Graphs";
    }

    public String getDescription(Locale locale) {
        return "This document provides links to graphs that make it easier to visualize the project's dependencies";
    }

    public boolean isExternalReport() {
        return false;
    }

    public boolean canGenerateReport() {
        return true;
    }

    public File getReportOutputDirectory() {
        return this.reportOutputDirectory;
    }

    public void setReportOutputDirectory(File reportOutputDirectory) {
        this.reportOutputDirectory = reportOutputDirectory;
    }

    public String getSubDirectory() {
        return this.subDirectory;
    }

    public void setSubDirectory(String subDirectory) {
        this.subDirectory = subDirectory;
    }

    protected boolean isEmpty(List<Category> categories) {
        if (Helper.isEmpty(categories)) {
            return true;
        }
        for (Category category : categories) {
            if (this.isEmpty(category)) continue;
            return false;
        }
        return true;
    }

    protected boolean isEmpty(Category category) {
        if (Helper.isEmpty(category.getRows())) {
            return true;
        }
        return this.isEmptyRows(category.getRows());
    }

    protected boolean isEmptyRows(List<Row> rows) {
        if (Helper.isEmpty(rows)) {
            return true;
        }
        for (Row row : rows) {
            if (Helper.isEmpty(row.getDescriptors())) continue;
            return false;
        }
        return true;
    }

    protected boolean isEmpty(Row row) {
        return Helper.isEmpty(row.getDescriptors());
    }

    public List<Category> getCategories() {
        return this.categories;
    }

    public void setCategories(List<Category> categories) {
        this.categories = categories;
    }
}

