/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.util.List;
import org.kuali.maven.plugins.graph.dot.EdgeGenerator;
import org.kuali.maven.plugins.graph.pojo.Conflicts;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;

public class HideConflictsProcessor
implements Processor {
    TreeHelper helper = new TreeHelper();
    EdgeGenerator generator = new EdgeGenerator();
    GraphDescriptor descriptor;

    public HideConflictsProcessor() {
        this(null);
    }

    public HideConflictsProcessor(GraphDescriptor descriptor) {
        this.descriptor = descriptor;
    }

    @Override
    public void process(Node<MavenContext> root) {
        switch (this.descriptor.getLayout()) {
            case LINKED: {
                this.handleLinkedConflicts(root);
                return;
            }
            case FLAT: {
                this.handleFlatConflicts(root);
                return;
            }
        }
        throw new IllegalStateException("Unknown layout " + (Object)((Object)this.descriptor.getLayout()));
    }

    protected void handleLinkedConflicts(Node<MavenContext> root) {
        List<Node<MavenContext>> conflicts = this.helper.getNodeList(root, State.CONFLICT);
        for (Node<MavenContext> conflict : conflicts) {
            String replacementId = TreeHelper.getArtifactId(conflict.getObject().getReplacement());
            Node<MavenContext> replacement = TreeHelper.findRequiredIncludedNode(root, replacementId);
            Conflicts conflictMode = this.descriptor.getConflicts();
            State state = State.CONFLICT;
            if (conflictMode == Conflicts.IGNORE) {
                state = State.INCLUDED;
            }
            Edge edge = this.generator.getParentChildEdge(conflict, replacement, state);
            this.generator.addEdge((Node<MavenContext>)conflict.getParent(), edge);
            this.helper.hide(conflict);
        }
    }

    protected void handleFlatConflicts(Node<MavenContext> root) {
        List<Node<MavenContext>> conflicts = this.helper.getNodeList(root, State.CONFLICT);
        for (Node<MavenContext> conflict : conflicts) {
            this.helper.hide(conflict);
        }
    }

    public GraphDescriptor getDescriptor() {
        return this.descriptor;
    }

    public void setDescriptor(GraphDescriptor descriptor) {
        this.descriptor = descriptor;
    }
}

