/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import org.kuali.maven.plugins.graph.dot.EdgeGenerator;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.Scope;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LinkedEdgeProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(LinkedEdgeProcessor.class);
    public static final String REPLACEMENT_LABEL = "replacement";
    EdgeGenerator generator = new EdgeGenerator();

    @Override
    public void process(Node<MavenContext> node) {
        for (Node<MavenContext> child : node.getChildren()) {
            Edge edge = this.generator.getParentChildEdge(child);
            this.generator.addEdge((Node<MavenContext>)child.getParent(), edge);
            this.handleState(child);
            this.process(child);
        }
    }

    protected void handleState(Node<MavenContext> node) {
        logger.debug("handling node {}", (Object)node.getObject().getId());
        switch (node.getObject().getState()) {
            case INCLUDED: 
            case CYCLIC: 
            case UNKNOWN: {
                return;
            }
            case DUPLICATE: {
                this.handleDuplicate(node);
                return;
            }
            case CONFLICT: {
                this.handleConflict(node);
                return;
            }
        }
        throw new IllegalStateException("Unknown state " + (Object)((Object)node.getObject().getState()));
    }

    protected void handleConflict(Node<MavenContext> node) {
        MavenContext context = node.getObject();
        String replacementId = TreeHelper.getArtifactId(context.getReplacement());
        Node<MavenContext> replacement = TreeHelper.findRequiredIncludedNode((Node<MavenContext>)node.getRoot(), replacementId);
        GraphNode parent = context.getGraphNode();
        GraphNode child = replacement.getObject().getGraphNode();
        boolean optional = context.isOptional();
        Edge edge = this.generator.getStyledEdge(parent, child, optional, Scope.DEFAULT_SCOPE, State.CONFLICT);
        edge.setLabel(REPLACEMENT_LABEL);
        this.generator.addEdge(node, edge);
    }

    protected void handleDuplicate(Node<MavenContext> node) {
        MavenContext context = node.getObject();
        String id = context.getArtifactIdentifier();
        Node<MavenContext> replacement = TreeHelper.findRequiredIncludedNode((Node<MavenContext>)node.getRoot(), id);
        GraphNode parent = ((MavenContext)((Node)node.getParent()).getObject()).getGraphNode();
        GraphNode child = replacement.getObject().getGraphNode();
        boolean optional = context.isOptional();
        Scope scope = Scope.getScope(context.getArtifact().getScope());
        Edge edge = this.generator.getStyledEdge(parent, child, optional, scope, State.INCLUDED);
        this.generator.addEdge((Node<MavenContext>)node.getParent(), edge);
    }
}

