/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.util.ArrayList;
import java.util.List;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.mojo.MojoHelper;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;

public class PathDisplayProcessor
implements Processor {
    public static final boolean DEFAULT_SHOW_SUB_TREES_VALUE = true;
    MojoHelper mh = new MojoHelper();
    TreeHelper helper = new TreeHelper();
    GraphDescriptor graphDescriptor;
    boolean showSubTrees = true;

    public PathDisplayProcessor() {
        this(null);
    }

    public PathDisplayProcessor(GraphDescriptor graphDescriptor) {
        this(graphDescriptor, true);
    }

    public PathDisplayProcessor(GraphDescriptor graphDescriptor, boolean showSubTrees) {
        this.graphDescriptor = graphDescriptor;
        this.showSubTrees = showSubTrees;
    }

    @Override
    public void process(Node<MavenContext> node) {
        Filter<Node<MavenContext>> filter = this.mh.getIncludeExcludeFilter(this.graphDescriptor);
        List<Node<MavenContext>> list = node.getBreadthFirstList();
        ArrayList<Node<MavenContext>> displayed = new ArrayList<Node<MavenContext>>();
        for (Node<MavenContext> element : list) {
            this.helper.hide(element);
            boolean display = filter.isMatch(element) || element.isRoot();
            if (!display) continue;
            displayed.add(element);
        }
        for (Node<MavenContext> element : displayed) {
            this.helper.showPath(element);
            if (element.isRoot() || !this.showSubTrees) continue;
            this.helper.showTree(element);
        }
    }

    public GraphDescriptor getGraphDescriptor() {
        return this.graphDescriptor;
    }

    public void setGraphDescriptor(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
    }

    public boolean isShowSubTrees() {
        return this.showSubTrees;
    }

    public void setShowSubTrees(boolean showSubTrees) {
        this.showSubTrees = showSubTrees;
    }
}

