/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.util.ArrayList;
import java.util.List;
import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.mojo.MojoHelper;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathTreeDisplayProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(PathTreeDisplayProcessor.class);
    MojoHelper mh = new MojoHelper();
    TreeHelper helper = new TreeHelper();
    GraphDescriptor graphDescriptor;

    public PathTreeDisplayProcessor() {
        this(null);
    }

    public PathTreeDisplayProcessor(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
    }

    @Override
    public void process(Node<MavenContext> node) {
        Filter<Node<MavenContext>> filter = this.mh.getIncludeExcludeFilter(this.graphDescriptor);
        List<Node<MavenContext>> list = node.getBreadthFirstList();
        ArrayList<Node<MavenContext>> displayed = new ArrayList<Node<MavenContext>>();
        for (Node<MavenContext> element : list) {
            boolean display;
            if (!element.isRoot()) {
                this.helper.hide(element);
            }
            if (!(display = filter.isMatch(element))) continue;
            displayed.add(element);
            logger.debug("displaying " + element.getObject().getArtifactIdentifier());
        }
        for (Node<MavenContext> element : displayed) {
            this.helper.showPath(element);
            this.helper.showTree(element);
            this.showDuplicates(element);
        }
    }

    protected void showDuplicates(Node<MavenContext> node) {
        for (Node<MavenContext> child : node.getChildren()) {
            boolean correctState = State.DUPLICATE == child.getObject().getState();
            if (!correctState) continue;
            String artifactId = child.getObject().getArtifactIdentifier();
            Node<MavenContext> included = TreeHelper.findRequiredIncludedNode((Node<MavenContext>)node.getRoot(), artifactId);
            this.helper.showTree(included);
            this.helper.showPath(included);
            this.showDuplicates(child);
        }
    }

    public GraphDescriptor getGraphDescriptor() {
        return this.graphDescriptor;
    }

    public void setGraphDescriptor(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
    }
}

