/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.util.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceClutterProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(ReduceClutterProcessor.class);
    int removeCount = 0;

    @Override
    public void process(Node<MavenContext> node) {
        this.recurse(node);
        logger.debug("removed {} redundant edges", (Object)this.removeCount);
    }

    protected void recurse(Node<MavenContext> node) {
        this.handleEdges(node);
        for (Node<MavenContext> child : node.getChildren()) {
            this.recurse(child);
        }
    }

    protected void handleEdges(Node<MavenContext> node) {
        List<Edge> edges = Helper.toEmptyList(node.getObject().getGraphNode().getEdges());
        List<Edge> edgesToRemove = this.getEdgesToRemove(edges, node);
        this.remove(edges, edgesToRemove);
    }

    protected List<Edge> getEdgesToRemove(List<Edge> edges, Node<MavenContext> node) {
        ArrayList<Edge> edgesToRemove = new ArrayList<Edge>();
        for (Edge edge : edges) {
            boolean redundant = this.isRedundantEdge(edge, edges, node);
            if (!redundant) continue;
            edgesToRemove.add(edge);
        }
        return edgesToRemove;
    }

    protected boolean isRedundantEdge(Edge edge, List<Edge> edges, Node<MavenContext> node) {
        List<Edge> subList = this.getEdgesThatAreNotMe(edge, edges);
        GraphNode child = edge.getChild();
        return this.isReachable(child, subList, node);
    }

    protected void remove(List<Edge> edges, List<Edge> edgesToRemove) {
        Iterator<Edge> itr = edges.iterator();
        while (itr.hasNext()) {
            Edge edge = itr.next();
            boolean contains = this.contains(edgesToRemove, edge);
            if (!contains) continue;
            itr.remove();
            logger.debug("removing edge {}", (Object)edge.getId());
            ++this.removeCount;
        }
    }

    protected boolean contains(List<Edge> edges, Edge edge) {
        for (Edge element : edges) {
            if (edge.getId() != element.getId()) continue;
            return true;
        }
        return false;
    }

    protected boolean isReachable(GraphNode graphNode, List<Edge> edges, Node<MavenContext> node) {
        ArrayList<Node<MavenContext>> list = new ArrayList<Node<MavenContext>>();
        this.recursivelyFillNodeList(node, edges, list);
        logger.debug("nodeList.size()={}", (Object)list.size());
        for (Node node2 : list) {
            MavenContext context = (MavenContext)node2.getObject();
            GraphNode gn = context.getGraphNode();
            if (gn.getId() != graphNode.getId()) continue;
            return true;
        }
        return false;
    }

    protected boolean isInclude(Node<MavenContext> node, List<Node<MavenContext>> list, Edge edge) {
        boolean hidden = edge.getParent().isHidden() || edge.getChild().isHidden();
        State state = node.getObject().getState();
        return !hidden && state != State.CONFLICT && !this.contains(list, node);
    }

    protected void recursivelyFillNodeList(Node<MavenContext> node, List<Edge> edges, List<Node<MavenContext>> list) {
        edges = Helper.toEmptyList(edges);
        for (Edge edge : edges) {
            GraphNode graphNode = edge.getChild();
            Node<MavenContext> foundNode = this.findRequiredNode(node, graphNode.getId());
            boolean recurse = this.isInclude(foundNode, list, edge);
            if (!recurse) continue;
            list.add(foundNode);
            List<Edge> foundEdges = foundNode.getObject().getGraphNode().getEdges();
            this.recursivelyFillNodeList(node, foundEdges, list);
        }
    }

    protected boolean contains(List<Node<MavenContext>> list, Node<MavenContext> node) {
        int targetId = node.getObject().getId();
        for (Node<MavenContext> element : list) {
            int id = element.getObject().getId();
            if (id != targetId) continue;
            return true;
        }
        return false;
    }

    protected Node<MavenContext> findRequiredNode(Node<MavenContext> node, int graphNodeId) {
        List list = ((Node)node.getRoot()).getBreadthFirstList();
        for (Node<MavenContext> node2 : list) {
            MavenContext context = (MavenContext)node2.getObject();
            GraphNode graphNode = context.getGraphNode();
            if (graphNode.getId() != graphNodeId) continue;
            return node2;
        }
        throw new IllegalStateException("Can't locate a node for graph node id " + graphNodeId);
    }

    protected List<Edge> getEdgesThatAreNotMe(Edge me, List<Edge> edges) {
        ArrayList<Edge> newEdges = new ArrayList<Edge>();
        for (Edge edge : edges) {
            if (edge.getId() == me.getId()) continue;
            newEdges.add(edge);
        }
        return newEdges;
    }
}

