/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.util.ArrayList;
import java.util.List;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.sanitize.BuildSanitizer;
import org.kuali.maven.plugins.graph.sanitize.NodeSanitizer;
import org.kuali.maven.plugins.graph.sanitize.RelatedArtifactSanitizer;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SanitizingProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(SanitizingProcessor.class);
    TreeHelper helper = new TreeHelper();

    @Override
    public void process(Node<MavenContext> node) {
        List<Node<MavenContext>> nodes = node.getBreadthFirstList();
        int included = this.helper.getList(node, State.INCLUDED).size();
        logger.debug("Sanitizing metadata for " + nodes.size() + " dependency nodes (" + included + " unique artifacts in the build)");
        List<NodeSanitizer<MavenContext>> sanitizers = this.getSanitizers(node);
        for (NodeSanitizer<MavenContext> sanitizer : sanitizers) {
            sanitizer.sanitize((MavenContext)((Object)node));
        }
    }

    protected List<NodeSanitizer<MavenContext>> getSanitizers(Node<MavenContext> node) {
        ArrayList<NodeSanitizer<MavenContext>> sanitizers = new ArrayList<NodeSanitizer<MavenContext>>();
        sanitizers.add(new RelatedArtifactSanitizer());
        sanitizers.add(new BuildSanitizer());
        return sanitizers;
    }
}

