/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.io.IOUtils;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.Scope;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.pojo.Style;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.kuali.maven.plugins.graph.util.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;

public class StyleProcessor
implements Processor {
    private static final Logger logger = LoggerFactory.getLogger(StyleProcessor.class);
    TreeHelper helper = new TreeHelper();
    Properties properties = this.getProperties();

    @Override
    public void process(Node<MavenContext> node) {
        List<Node<MavenContext>> list = node.getBreadthFirstList();
        for (Node<MavenContext> element : list) {
            this.updateGraphNodeStyle(element.getObject());
        }
    }

    protected Properties getProperties() {
        Properties properties;
        String location = "classpath:dot.properties";
        DefaultResourceLoader loader = new DefaultResourceLoader();
        Resource resource = loader.getResource(location);
        InputStream in = null;
        try {
            Properties properties2 = new Properties();
            in = resource.getInputStream();
            properties2.load(in);
            properties = properties2;
        }
        catch (IOException e) {
            try {
                throw new IllegalStateException(e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        return properties;
    }

    protected String getStyle(String property, Scope scope, boolean optional, State state) {
        String key1 = "state." + state.getValue() + "." + property;
        String key2 = "scope." + scope.getValue() + "." + property;
        String key3 = "optional." + property;
        String value1 = this.properties.getProperty(key1);
        String value2 = this.properties.getProperty(key2);
        String value3 = this.properties.getProperty(key3);
        if (!Helper.isBlank(value1)) {
            return value1;
        }
        if (!Helper.isBlank(value2)) {
            return value2;
        }
        if (!Helper.isBlank(value3) && optional) {
            return value3;
        }
        return null;
    }

    protected List<String> getStyleProperties() {
        try {
            Map map = BeanUtils.describe((Object)Style.DEFAULT_STYLE);
            map.remove("class");
            return new ArrayList<String>(map.keySet());
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public Style getStyle(Scope scope, boolean optional, State state) {
        scope = scope == null ? Scope.DEFAULT_SCOPE : scope;
        state = state == null ? State.INCLUDED : state;
        List<String> properties = this.getStyleProperties();
        Style style = new Style();
        for (String property : properties) {
            String value = this.getStyle(property, scope, optional, state);
            if (Helper.isBlank(value)) continue;
            this.helper.copyProperty(style, property, value);
        }
        return style;
    }

    public void updateGraphNodeStyle(MavenContext context) {
        DependencyNode dn = context.getDependencyNode();
        boolean optional = context.isOptional();
        State state = context.getState();
        Scope scope = Scope.getScope(dn.getArtifact().getScope());
        Style style = this.getStyle(scope, optional, state);
        if (optional) {
            logger.debug("optional {}, style={}", (Object)context.getArtifactIdentifier(), (Object)style.getStyle());
        }
        this.copyStyleProperties(context.getGraphNode(), style);
        if (optional) {
            context.getGraphNode().setStyle("dotted,filled");
        } else {
            context.getGraphNode().setStyle("solid,filled");
        }
    }

    public void copyStyleProperties(Object dest, Style style) {
        List<String> names = this.getStyleProperties();
        for (String name : names) {
            String value = this.helper.getProperty(style, name);
            if (Helper.isBlank(value)) continue;
            this.helper.copyProperty(dest, name, value);
        }
    }
}

