/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.processor;

import org.kuali.maven.plugins.graph.filter.Filter;
import org.kuali.maven.plugins.graph.mojo.MojoHelper;
import org.kuali.maven.plugins.graph.pojo.GraphDescriptor;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.processor.Processor;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;

public class TreeDisplayProcessor
implements Processor {
    MojoHelper mh = new MojoHelper();
    TreeHelper helper = new TreeHelper();
    GraphDescriptor graphDescriptor;

    public TreeDisplayProcessor() {
        this(null);
    }

    public TreeDisplayProcessor(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
    }

    @Override
    public void process(Node<MavenContext> node) {
        Filter<Node<MavenContext>> filter = this.mh.getIncludeExcludeFilter(this.graphDescriptor);
        this.filter(node, filter);
    }

    public void filter(Node<MavenContext> node, Filter<Node<MavenContext>> filter) {
        boolean hide;
        boolean bl = hide = !filter.isMatch(node) && !node.isRoot();
        if (hide) {
            this.helper.hideTree(node);
        } else {
            for (Node<MavenContext> child : node.getChildren()) {
                this.filter(child, filter);
            }
        }
    }

    public GraphDescriptor getGraphDescriptor() {
        return this.graphDescriptor;
    }

    public void setGraphDescriptor(GraphDescriptor graphDescriptor) {
        this.graphDescriptor = graphDescriptor;
    }
}

