/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.sanitize;

import java.util.List;
import java.util.Map;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.sanitize.NodeSanitizer;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class BuildSanitizer
implements NodeSanitizer<MavenContext> {
    private static final Logger logger = LoggerFactory.getLogger(BuildSanitizer.class);
    TreeHelper helper = new TreeHelper();

    @Override
    public void sanitize(Node<MavenContext> node) {
        List<MavenContext> included = this.helper.getList(node, State.INCLUDED);
        List<MavenContext> duplicates = this.helper.getList(node, State.DUPLICATE);
        List<MavenContext> conflicts = this.helper.getList(node, State.CONFLICT);
        for (MavenContext duplicate : duplicates) {
            this.sanitizeDuplicate(duplicate, included);
        }
        for (MavenContext conflict : conflicts) {
            this.sanitizeConflict(conflict, included);
        }
    }

    protected void sanitizeDuplicate(MavenContext duplicate, List<MavenContext> included) {
        Map<String, MavenContext> ids = this.helper.getMap(included);
        Map<String, MavenContext> partialIds = this.helper.getPartialIdMap(included);
        MavenContext exact = ids.get(duplicate.getArtifactIdentifier());
        if (exact != null) {
            logger.debug("verified duplicate {}", (Object)duplicate.getArtifact());
            return;
        }
        String partialId = TreeHelper.getPartialArtifactId(duplicate.getArtifact());
        MavenContext similar = partialIds.get(partialId);
        if (similar != null) {
            duplicate.setState(State.CONFLICT);
            duplicate.setReplacement(similar.getArtifact());
            logger.info("duplicate->conflict {}", (Object)duplicate.getArtifact());
        } else {
            logger.warn("duplicate->unknown {}", (Object)duplicate.getArtifact());
            duplicate.setState(State.UNKNOWN);
        }
    }

    protected void sanitizeConflict(MavenContext conflict, List<MavenContext> included) {
        Map<String, MavenContext> ids = this.helper.getMap(included);
        Map<String, MavenContext> partialIds = this.helper.getPartialIdMap(included);
        String partialId1 = TreeHelper.getPartialArtifactId(conflict.getReplacement());
        String partialId2 = TreeHelper.getPartialArtifactId(conflict.getArtifact());
        Assert.isTrue((boolean)partialId1.equals(partialId2), (String)"Invalid state");
        MavenContext exactMain = ids.get(conflict.getArtifactIdentifier());
        String replacementId = TreeHelper.getArtifactId(conflict.getReplacement());
        MavenContext exactRelated = ids.get(replacementId);
        MavenContext similar = partialIds.get(partialId1);
        if (exactMain == null && exactRelated == null && similar == null) {
            conflict.setState(State.UNKNOWN);
            logger.warn("conflict->unknown {}", (Object)conflict.getArtifactIdentifier());
            return;
        }
        if (exactMain != null) {
            conflict.setState(State.DUPLICATE);
            conflict.setReplacement(null);
            logger.info("conflict->duplicate {}", (Object)conflict.getArtifactIdentifier());
        } else if (exactRelated != null) {
            conflict.setReplacement(exactRelated.getArtifact());
            logger.debug("verified conflict {}", (Object)conflict.getArtifactIdentifier());
        } else if (similar != null) {
            conflict.setReplacement(similar.getArtifact());
            String newId = TreeHelper.getArtifactId(similar.getArtifact());
            String oldId = replacementId;
            logger.warn("changed replacement {}->{}", (Object)oldId, (Object)newId);
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid state");
        }
    }
}

