/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.sanitize;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.sanitize.NodeSanitizer;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.tree.TreeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class RelatedArtifactSanitizer
implements NodeSanitizer<MavenContext> {
    private static final Logger logger = LoggerFactory.getLogger(RelatedArtifactSanitizer.class);
    TreeHelper helper = new TreeHelper();

    @Override
    public void sanitize(Node<MavenContext> node) {
        List<MavenContext> contexts = this.helper.getList(node, State.DUPLICATE, State.CONFLICT);
        for (MavenContext context : contexts) {
            this.sanitize(context);
        }
    }

    @Override
    protected void sanitize(MavenContext context) {
        DependencyNode dn = context.getDependencyNode();
        Artifact artifact = dn.getArtifact();
        Artifact related = dn.getRelatedArtifact();
        State state = State.getState(dn.getState());
        boolean equal = this.helper.equals(artifact, related);
        boolean similar = this.helper.similar(artifact, related);
        Assert.isTrue((equal || similar ? 1 : 0) != 0, (String)"Invalid state.");
        if (equal) {
            if (state == State.CONFLICT) {
                logger.info((Object)((Object)State.CONFLICT) + "->" + (Object)((Object)State.DUPLICATE) + " " + artifact);
            }
            context.setState(State.DUPLICATE);
            context.setReplacement(null);
        } else if (similar) {
            if (state == State.DUPLICATE) {
                logger.info((Object)((Object)State.DUPLICATE) + "->" + (Object)((Object)State.CONFLICT) + " " + artifact);
            }
            context.setState(State.CONFLICT);
            context.setReplacement(related);
        } else {
            Assert.isTrue((boolean)false, (String)"Invalid state");
        }
    }
}

