/*
 * Decompiled with CFR 0.152.
 */
package org.kuali.maven.plugins.graph.tree;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.codehaus.plexus.util.StringUtils;
import org.kuali.maven.plugins.graph.collector.ArtifactIdTokenCollector;
import org.kuali.maven.plugins.graph.collector.VersionFreeArtifactTokenCollector;
import org.kuali.maven.plugins.graph.dot.GraphHelper;
import org.kuali.maven.plugins.graph.filter.NodeFilter;
import org.kuali.maven.plugins.graph.pojo.Edge;
import org.kuali.maven.plugins.graph.pojo.GraphNode;
import org.kuali.maven.plugins.graph.pojo.MavenContext;
import org.kuali.maven.plugins.graph.pojo.Scope;
import org.kuali.maven.plugins.graph.pojo.State;
import org.kuali.maven.plugins.graph.tree.Node;
import org.kuali.maven.plugins.graph.util.Counter;
import org.kuali.maven.plugins.graph.util.Helper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class TreeHelper {
    private static final Logger logger = LoggerFactory.getLogger(TreeHelper.class);
    public static final String ROOT_FILL_COLOR = "#dddddd";
    public static final String OPTIONAL = "optional";
    public static final String REQUIRED = "required";
    Counter counter = new Counter();
    GraphHelper graphHelper = new GraphHelper();

    public Node<MavenContext> copy(Node<MavenContext> node) {
        Node<MavenContext> newNode = new Node<MavenContext>();
        MavenContext newMavenContext = this.copyWithoutEdges(node.getObject());
        newNode.setObject(newMavenContext);
        for (Node<MavenContext> child : node.getChildren()) {
            Node<MavenContext> newChild = this.copy(child);
            newNode.add(newChild);
        }
        return newNode;
    }

    public MavenContext copyWithoutEdges(MavenContext context) {
        MavenContext copy = this.copy(context);
        copy.getGraphNode().setEdges(null);
        return copy;
    }

    public MavenContext copy(MavenContext context) {
        GraphNode newGraphNode = Helper.copyProperties(GraphNode.class, context.getGraphNode());
        MavenContext newContext = Helper.copyProperties(MavenContext.class, context);
        newContext.setGraphNode(newGraphNode);
        return newContext;
    }

    public static Node<MavenContext> findRequiredIncludedNode(Node<MavenContext> root, String artifactId) {
        List<Node<MavenContext>> nodes = root.getBreadthFirstList();
        for (Node<MavenContext> node : nodes) {
            MavenContext context = node.getObject();
            State state = context.getState();
            String artifactIdentifier = context.getArtifactIdentifier();
            boolean correctState = state == State.INCLUDED;
            boolean correctArtifact = artifactId.equals(artifactIdentifier);
            if (!correctState || !correctArtifact) continue;
            return node;
        }
        throw new IllegalStateException("Can't locate " + artifactId);
    }

    public void include(Node<MavenContext> node, NodeFilter<MavenContext> filter) {
        if (!filter.isMatch((MavenContext)((Object)node)) && !node.isRoot()) {
            this.hide(node);
            logger.debug("i:hiding {}", (Object)node.getObject().getArtifactIdentifier());
        } else {
            logger.debug("i:showing path {}", (Object)node.getObject().getArtifactIdentifier());
            this.showPath(node);
        }
        for (Node<MavenContext> child : node.getChildren()) {
            this.include(child, filter);
        }
    }

    public void exclude(Node<MavenContext> node, NodeFilter<MavenContext> filter) {
        if (filter.isMatch((MavenContext)((Object)node)) && !node.isRoot()) {
            logger.debug("e:hiding {}", (Object)node.getObject().getArtifactIdentifier());
            this.hideTree(node);
        }
        for (Node<MavenContext> child : node.getChildren()) {
            this.exclude(child, filter);
        }
    }

    public void showPath(Node<MavenContext> node) {
        Node<MavenContext>[] path = node.getPath();
        List<Node<MavenContext>> pathList = Arrays.asList(path);
        Collections.reverse(pathList);
        for (Node<MavenContext> pathNode : pathList) {
            this.show(pathNode);
        }
    }

    public void hideTree(Node<MavenContext> node) {
        this.hide(node);
        for (Node<MavenContext> child : node.getChildren()) {
            this.hideTree(child);
        }
    }

    public void showTree(Node<MavenContext> node) {
        this.show(node);
        for (Node<MavenContext> child : node.getChildren()) {
            this.showTree(child);
        }
    }

    public void show(Node<MavenContext> node) {
        MavenContext context = node.getObject();
        GraphNode gn = context.getGraphNode();
        if (gn.isHidden()) {
            logger.debug("showing node {}: {}", (Object)this.lpad(context.getId(), 4), (Object)context.getArtifactIdentifier());
            gn.setHidden(false);
        }
    }

    public void hide(Node<MavenContext> node) {
        MavenContext context = node.getObject();
        GraphNode gn = node.getObject().getGraphNode();
        if (!gn.isHidden()) {
            logger.debug(" hiding node {}: {}", (Object)this.lpad(context.getId(), 4), (Object)context.getArtifactIdentifier());
            gn.setHidden(true);
        }
    }

    public <T> void prune(Node<T> node, NodeFilter<T> filter) {
        if (!filter.isMatch(node)) {
            if (node.isRoot()) {
                logger.debug("removing all children from root");
                node.removeAllChildren();
            } else {
                logger.debug("removing node at level={}", (Object)node.getLevel());
                node.removeFromParent();
            }
        } else {
            for (Node<T> child : node.getChildren()) {
                this.prune(child, filter);
            }
        }
    }

    protected MavenContext getMavenContext(GraphNode gn, DependencyNode dn) {
        int id = gn.getId();
        String artifactIdentifier = TreeHelper.getArtifactId(dn.getArtifact());
        MavenContext context = new MavenContext();
        context.setId(id);
        context.setArtifactIdentifier(artifactIdentifier);
        context.setArtifact(dn.getArtifact());
        context.setGraphNode(gn);
        context.setDependencyNode(dn);
        context.setState(State.getState(dn.getState()));
        context.setOptional(dn.getArtifact().isOptional());
        return context;
    }

    public Node<MavenContext> getTree(DependencyNode dependencyNode) {
        GraphNode gn = this.getGraphNode(dependencyNode);
        MavenContext context = this.getMavenContext(gn, dependencyNode);
        Node<MavenContext> node = new Node<MavenContext>(context);
        List children = dependencyNode.getChildren();
        for (DependencyNode child : children) {
            node.add(this.getTree(child));
        }
        return node;
    }

    public boolean equals(Artifact a1, Artifact a2) {
        String id1 = TreeHelper.getArtifactId(a1);
        String id2 = TreeHelper.getArtifactId(a2);
        return id1.equals(id2);
    }

    public boolean similar(Artifact a1, Artifact a2) {
        String n1 = TreeHelper.getPartialArtifactId(a1);
        String n2 = TreeHelper.getPartialArtifactId(a2);
        return n1.equals(n2);
    }

    protected boolean isMatch(State state, State[] states) {
        for (State s : states) {
            if (state != s) continue;
            return true;
        }
        return false;
    }

    public List<Node<MavenContext>> getNodeList(Node<MavenContext> node, State ... states) {
        Assert.notNull((Object)states, (String)"states are required");
        ArrayList<Node<MavenContext>> contexts = new ArrayList<Node<MavenContext>>();
        for (Node<MavenContext> element : node.getBreadthFirstList()) {
            MavenContext context = element.getObject();
            State elementState = context.getState();
            if (!this.isMatch(elementState, states)) continue;
            contexts.add(element);
        }
        return contexts;
    }

    public List<MavenContext> getList(Node<MavenContext> node, State ... states) {
        Assert.notNull((Object)states, (String)"states are required");
        ArrayList<MavenContext> contexts = new ArrayList<MavenContext>();
        for (Node<MavenContext> element : node.getBreadthFirstList()) {
            MavenContext context = element.getObject();
            State elementState = context.getState();
            if (!this.isMatch(elementState, states)) continue;
            contexts.add(context);
        }
        return contexts;
    }

    public Map<String, MavenContext> getMap(List<MavenContext> contexts) {
        HashMap<String, MavenContext> map = new HashMap<String, MavenContext>();
        for (MavenContext context : contexts) {
            map.put(context.getArtifactIdentifier(), context);
        }
        return map;
    }

    public Map<String, MavenContext> getPartialIdMap(List<MavenContext> contexts) {
        HashMap<String, MavenContext> map = new HashMap<String, MavenContext>();
        for (MavenContext context : contexts) {
            map.put(TreeHelper.getPartialArtifactId(context.getArtifact()), context);
        }
        return map;
    }

    protected <T> void show(String label, List<T> list) {
        logger.info(label);
        for (T element : list) {
            logger.info(element.toString());
        }
    }

    protected GraphNode getGraphNode(DependencyNode dn) {
        Artifact a = dn.getArtifact();
        GraphNode n = new GraphNode();
        n.setId(this.counter.increment());
        n.setLabel(this.graphHelper.getLabel(a));
        String fillcolor = dn.getParent() == null ? ROOT_FILL_COLOR : n.getFillcolor();
        n.setFillcolor(fillcolor);
        return n;
    }

    public List<GraphNode> getGraphNodes(Node<MavenContext> node) {
        ArrayList<GraphNode> nodes = new ArrayList<GraphNode>();
        List<Node<MavenContext>> treeNodes = node.getBreadthFirstList();
        for (Node<MavenContext> treeNode : treeNodes) {
            nodes.add(treeNode.getObject().getGraphNode());
        }
        return nodes;
    }

    public List<Edge> getEdges(Node<MavenContext> node) {
        ArrayList<Edge> edges = new ArrayList<Edge>();
        List<Node<MavenContext>> list = node.getBreadthFirstList();
        for (Node<MavenContext> element : list) {
            MavenContext context = element.getObject();
            GraphNode graphNode = context.getGraphNode();
            Helper.addAll(edges, graphNode.getEdges());
        }
        return edges;
    }

    public static String getRelationshipLabel(Scope scope, boolean optional, State state) {
        ArrayList<String> labelTokens = new ArrayList<String>();
        if (!Scope.DEFAULT_SCOPE.equals((Object)scope)) {
            labelTokens.add(scope.name().toLowerCase());
        }
        if (optional) {
            // empty if block
        }
        if (!State.INCLUDED.equals((Object)state)) {
            labelTokens.add(state.getValue());
        }
        return TreeHelper.toIdString(labelTokens);
    }

    public static String toIdString(List<String> strings) {
        return TreeHelper.toIdString(Helper.toArray(strings));
    }

    public static String toIdString(String ... strings) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < strings.length; ++i) {
            if (i != 0) {
                sb.append(":");
            }
            sb.append(Helper.toEmpty(strings[i]));
        }
        return sb.toString();
    }

    public String getProperty(Object bean, String name) {
        try {
            return BeanUtils.getProperty((Object)bean, (String)name);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void copyProperty(Object bean, String name, Object value) {
        try {
            BeanUtils.copyProperty((Object)bean, (String)name, (Object)value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void show(List<GraphNode> nodes, List<Edge> edges) {
        int nodeCount = nodes.size();
        int edgeCount = edges.size();
        int nodeCountShown = this.getNodeCount(nodes);
        int edgeCountShown = this.getEdgeCount(edges);
        int nodeCountHidden = nodeCount - nodeCountShown;
        int edgeCountHidden = edgeCount - edgeCountShown;
        logger.info("Generated " + nodes.size() + " graph nodes and " + edges.size() + " edges");
        logger.info("Showing " + nodeCountShown + " nodes and " + edgeCountShown + " edges");
        logger.info("Hiding " + nodeCountHidden + " nodes and " + edgeCountHidden + " edges");
    }

    protected int getEdgeCount(List<Edge> edges) {
        int count = 0;
        for (Edge edge : edges) {
            GraphNode parent = edge.getParent();
            GraphNode child = edge.getChild();
            boolean hidden = parent.isHidden() || child.isHidden();
            count = hidden ? count : ++count;
        }
        return count;
    }

    protected int getNodeCount(List<GraphNode> nodes) {
        int count = 0;
        for (GraphNode node : nodes) {
            count = node.isHidden() ? count : ++count;
        }
        return count;
    }

    public static String getPartialArtifactId(Artifact a) {
        VersionFreeArtifactTokenCollector collector = new VersionFreeArtifactTokenCollector();
        return TreeHelper.toIdString(collector.getTokens(a));
    }

    public static String getArtifactId(Artifact a) {
        ArtifactIdTokenCollector collector = new ArtifactIdTokenCollector();
        return TreeHelper.toIdString(collector.getTokens(a));
    }

    protected String lpad(Object o, int count) {
        String s = Helper.toEmpty(o);
        return StringUtils.leftPad((String)s, (int)count);
    }
}

